/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayClient;
import software.amazon.awssdk.services.storagegateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.storagegateway.model.ListTapesRequest;
import software.amazon.awssdk.services.storagegateway.model.ListTapesResponse;
import software.amazon.awssdk.services.storagegateway.model.TapeInfo;

public class ListTapesIterable
implements SdkIterable<ListTapesResponse> {
    private final StorageGatewayClient client;
    private final ListTapesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTapesIterable(StorageGatewayClient client, ListTapesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTapesResponseFetcher();
    }

    public Iterator<ListTapesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TapeInfo> tapeInfos() {
        Function<ListTapesResponse, Iterator> getIterator = response -> {
            if (response != null && response.tapeInfos() != null) {
                return response.tapeInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTapesResponseFetcher
    implements SyncPageFetcher<ListTapesResponse> {
        private ListTapesResponseFetcher() {
        }

        public boolean hasNextPage(ListTapesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public ListTapesResponse nextPage(ListTapesResponse previousPage) {
            if (previousPage == null) {
                return ListTapesIterable.this.client.listTapes(ListTapesIterable.this.firstRequest);
            }
            return ListTapesIterable.this.client.listTapes((ListTapesRequest)((Object)ListTapesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

