/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutomaticUpdatePolicy {
    ALL_VERSIONS("ALL_VERSIONS"),
    EMERGENCY_VERSIONS_ONLY("EMERGENCY_VERSIONS_ONLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutomaticUpdatePolicy> VALUE_MAP;
    private final String value;

    private AutomaticUpdatePolicy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutomaticUpdatePolicy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutomaticUpdatePolicy> knownValues() {
        EnumSet<AutomaticUpdatePolicy> knownValues = EnumSet.allOf(AutomaticUpdatePolicy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutomaticUpdatePolicy.class, AutomaticUpdatePolicy::toString);
    }
}

