/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.AutomaticTapeCreationRule;
import software.amazon.awssdk.services.storagegateway.model.AutomaticTapeCreationRulesCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAutomaticTapeCreationPolicyRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, UpdateAutomaticTapeCreationPolicyRequest> {
    private static final SdkField<List<AutomaticTapeCreationRule>> AUTOMATIC_TAPE_CREATION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutomaticTapeCreationRules").getter(UpdateAutomaticTapeCreationPolicyRequest.getter(UpdateAutomaticTapeCreationPolicyRequest::automaticTapeCreationRules)).setter(UpdateAutomaticTapeCreationPolicyRequest.setter(Builder::automaticTapeCreationRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticTapeCreationRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomaticTapeCreationRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(UpdateAutomaticTapeCreationPolicyRequest.getter(UpdateAutomaticTapeCreationPolicyRequest::gatewayARN)).setter(UpdateAutomaticTapeCreationPolicyRequest.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATIC_TAPE_CREATION_RULES_FIELD, GATEWAY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAutomaticTapeCreationPolicyRequest.memberNameToFieldInitializer();
    private final List<AutomaticTapeCreationRule> automaticTapeCreationRules;
    private final String gatewayARN;

    private UpdateAutomaticTapeCreationPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.automaticTapeCreationRules = builder.automaticTapeCreationRules;
        this.gatewayARN = builder.gatewayARN;
    }

    public final boolean hasAutomaticTapeCreationRules() {
        return this.automaticTapeCreationRules != null && !(this.automaticTapeCreationRules instanceof SdkAutoConstructList);
    }

    public final List<AutomaticTapeCreationRule> automaticTapeCreationRules() {
        return this.automaticTapeCreationRules;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutomaticTapeCreationRules() ? this.automaticTapeCreationRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutomaticTapeCreationPolicyRequest)) {
            return false;
        }
        UpdateAutomaticTapeCreationPolicyRequest other = (UpdateAutomaticTapeCreationPolicyRequest)((Object)obj);
        return this.hasAutomaticTapeCreationRules() == other.hasAutomaticTapeCreationRules() && Objects.equals(this.automaticTapeCreationRules(), other.automaticTapeCreationRules()) && Objects.equals(this.gatewayARN(), other.gatewayARN());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAutomaticTapeCreationPolicyRequest").add("AutomaticTapeCreationRules", this.hasAutomaticTapeCreationRules() ? this.automaticTapeCreationRules() : null).add("GatewayARN", (Object)this.gatewayARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomaticTapeCreationRules": {
                return Optional.ofNullable(clazz.cast(this.automaticTapeCreationRules()));
            }
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AutomaticTapeCreationRules", AUTOMATIC_TAPE_CREATION_RULES_FIELD);
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAutomaticTapeCreationPolicyRequest, T> g) {
        return obj -> g.apply((UpdateAutomaticTapeCreationPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private List<AutomaticTapeCreationRule> automaticTapeCreationRules = DefaultSdkAutoConstructList.getInstance();
        private String gatewayARN;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutomaticTapeCreationPolicyRequest model) {
            super(model);
            this.automaticTapeCreationRules(model.automaticTapeCreationRules);
            this.gatewayARN(model.gatewayARN);
        }

        public final List<AutomaticTapeCreationRule.Builder> getAutomaticTapeCreationRules() {
            List<AutomaticTapeCreationRule.Builder> result = AutomaticTapeCreationRulesCopier.copyToBuilder(this.automaticTapeCreationRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutomaticTapeCreationRules(Collection<AutomaticTapeCreationRule.BuilderImpl> automaticTapeCreationRules) {
            this.automaticTapeCreationRules = AutomaticTapeCreationRulesCopier.copyFromBuilder(automaticTapeCreationRules);
        }

        @Override
        public final Builder automaticTapeCreationRules(Collection<AutomaticTapeCreationRule> automaticTapeCreationRules) {
            this.automaticTapeCreationRules = AutomaticTapeCreationRulesCopier.copy(automaticTapeCreationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automaticTapeCreationRules(AutomaticTapeCreationRule ... automaticTapeCreationRules) {
            this.automaticTapeCreationRules(Arrays.asList(automaticTapeCreationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automaticTapeCreationRules(Consumer<AutomaticTapeCreationRule.Builder> ... automaticTapeCreationRules) {
            this.automaticTapeCreationRules(Stream.of(automaticTapeCreationRules).map(c -> (AutomaticTapeCreationRule)((AutomaticTapeCreationRule.Builder)AutomaticTapeCreationRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAutomaticTapeCreationPolicyRequest build() {
            return new UpdateAutomaticTapeCreationPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAutomaticTapeCreationPolicyRequest> {
        public Builder automaticTapeCreationRules(Collection<AutomaticTapeCreationRule> var1);

        public Builder automaticTapeCreationRules(AutomaticTapeCreationRule ... var1);

        public Builder automaticTapeCreationRules(Consumer<AutomaticTapeCreationRule.Builder> ... var1);

        public Builder gatewayARN(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

