/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowDatasetSource;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowS3Source;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowSourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataIntegrationFlowExecutionSourceInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataIntegrationFlowExecutionSourceInfo> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceType").getter(DataIntegrationFlowExecutionSourceInfo.getter(DataIntegrationFlowExecutionSourceInfo::sourceTypeAsString)).setter(DataIntegrationFlowExecutionSourceInfo.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()}).build();
    private static final SdkField<DataIntegrationFlowS3Source> S3_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Source").getter(DataIntegrationFlowExecutionSourceInfo.getter(DataIntegrationFlowExecutionSourceInfo::s3Source)).setter(DataIntegrationFlowExecutionSourceInfo.setter(Builder::s3Source)).constructor(DataIntegrationFlowS3Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Source").build()}).build();
    private static final SdkField<DataIntegrationFlowDatasetSource> DATASET_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("datasetSource").getter(DataIntegrationFlowExecutionSourceInfo.getter(DataIntegrationFlowExecutionSourceInfo::datasetSource)).setter(DataIntegrationFlowExecutionSourceInfo.setter(Builder::datasetSource)).constructor(DataIntegrationFlowDatasetSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD, S3_SOURCE_FIELD, DATASET_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataIntegrationFlowExecutionSourceInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceType;
    private final DataIntegrationFlowS3Source s3Source;
    private final DataIntegrationFlowDatasetSource datasetSource;

    private DataIntegrationFlowExecutionSourceInfo(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.s3Source = builder.s3Source;
        this.datasetSource = builder.datasetSource;
    }

    public final DataIntegrationFlowSourceType sourceType() {
        return DataIntegrationFlowSourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public final DataIntegrationFlowS3Source s3Source() {
        return this.s3Source;
    }

    public final DataIntegrationFlowDatasetSource datasetSource() {
        return this.datasetSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Source());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowExecutionSourceInfo)) {
            return false;
        }
        DataIntegrationFlowExecutionSourceInfo other = (DataIntegrationFlowExecutionSourceInfo)obj;
        return Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.s3Source(), other.s3Source()) && Objects.equals(this.datasetSource(), other.datasetSource());
    }

    public final String toString() {
        return ToString.builder((String)"DataIntegrationFlowExecutionSourceInfo").add("SourceType", (Object)this.sourceTypeAsString()).add("S3Source", (Object)this.s3Source()).add("DatasetSource", (Object)this.datasetSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "s3Source": {
                return Optional.ofNullable(clazz.cast(this.s3Source()));
            }
            case "datasetSource": {
                return Optional.ofNullable(clazz.cast(this.datasetSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceType", SOURCE_TYPE_FIELD);
        map.put("s3Source", S3_SOURCE_FIELD);
        map.put("datasetSource", DATASET_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowExecutionSourceInfo, T> g) {
        return obj -> g.apply((DataIntegrationFlowExecutionSourceInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceType;
        private DataIntegrationFlowS3Source s3Source;
        private DataIntegrationFlowDatasetSource datasetSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowExecutionSourceInfo model) {
            this.sourceType(model.sourceType);
            this.s3Source(model.s3Source);
            this.datasetSource(model.datasetSource);
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(DataIntegrationFlowSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final DataIntegrationFlowS3Source.Builder getS3Source() {
            return this.s3Source != null ? this.s3Source.toBuilder() : null;
        }

        public final void setS3Source(DataIntegrationFlowS3Source.BuilderImpl s3Source) {
            this.s3Source = s3Source != null ? s3Source.build() : null;
        }

        @Override
        public final Builder s3Source(DataIntegrationFlowS3Source s3Source) {
            this.s3Source = s3Source;
            return this;
        }

        public final DataIntegrationFlowDatasetSource.Builder getDatasetSource() {
            return this.datasetSource != null ? this.datasetSource.toBuilder() : null;
        }

        public final void setDatasetSource(DataIntegrationFlowDatasetSource.BuilderImpl datasetSource) {
            this.datasetSource = datasetSource != null ? datasetSource.build() : null;
        }

        @Override
        public final Builder datasetSource(DataIntegrationFlowDatasetSource datasetSource) {
            this.datasetSource = datasetSource;
            return this;
        }

        public DataIntegrationFlowExecutionSourceInfo build() {
            return new DataIntegrationFlowExecutionSourceInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataIntegrationFlowExecutionSourceInfo> {
        public Builder sourceType(String var1);

        public Builder sourceType(DataIntegrationFlowSourceType var1);

        public Builder s3Source(DataIntegrationFlowS3Source var1);

        default public Builder s3Source(Consumer<DataIntegrationFlowS3Source.Builder> s3Source) {
            return this.s3Source((DataIntegrationFlowS3Source)((DataIntegrationFlowS3Source.Builder)DataIntegrationFlowS3Source.builder().applyMutation(s3Source)).build());
        }

        public Builder datasetSource(DataIntegrationFlowDatasetSource var1);

        default public Builder datasetSource(Consumer<DataIntegrationFlowDatasetSource.Builder> datasetSource) {
            return this.datasetSource((DataIntegrationFlowDatasetSource)((DataIntegrationFlowDatasetSource.Builder)DataIntegrationFlowDatasetSource.builder().applyMutation(datasetSource)).build());
        }
    }
}

