/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.supplychain.SupplyChainClient;
import software.amazon.awssdk.services.supplychain.internal.UserAgentUtils;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationEvent;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsResponse;

public class ListDataIntegrationEventsIterable
implements SdkIterable<ListDataIntegrationEventsResponse> {
    private final SupplyChainClient client;
    private final ListDataIntegrationEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataIntegrationEventsIterable(SupplyChainClient client, ListDataIntegrationEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataIntegrationEventsResponseFetcher();
    }

    public Iterator<ListDataIntegrationEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataIntegrationEvent> events() {
        Function<ListDataIntegrationEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataIntegrationEventsResponseFetcher
    implements SyncPageFetcher<ListDataIntegrationEventsResponse> {
        private ListDataIntegrationEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataIntegrationEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataIntegrationEventsResponse nextPage(ListDataIntegrationEventsResponse previousPage) {
            if (previousPage == null) {
                return ListDataIntegrationEventsIterable.this.client.listDataIntegrationEvents(ListDataIntegrationEventsIterable.this.firstRequest);
            }
            return ListDataIntegrationEventsIterable.this.client.listDataIntegrationEvents((ListDataIntegrationEventsRequest)((Object)ListDataIntegrationEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

