/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.supplychain.SupplyChainAsyncClient;
import software.amazon.awssdk.services.supplychain.internal.UserAgentUtils;
import software.amazon.awssdk.services.supplychain.model.DataLakeNamespace;
import software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesResponse;

public class ListDataLakeNamespacesPublisher
implements SdkPublisher<ListDataLakeNamespacesResponse> {
    private final SupplyChainAsyncClient client;
    private final ListDataLakeNamespacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataLakeNamespacesPublisher(SupplyChainAsyncClient client, ListDataLakeNamespacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataLakeNamespacesPublisher(SupplyChainAsyncClient client, ListDataLakeNamespacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataLakeNamespacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataLakeNamespacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataLakeNamespace> namespaces() {
        Function<ListDataLakeNamespacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.namespaces() != null) {
                return response.namespaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataLakeNamespacesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataLakeNamespacesResponseFetcher
    implements AsyncPageFetcher<ListDataLakeNamespacesResponse> {
        private ListDataLakeNamespacesResponseFetcher() {
        }

        public boolean hasNextPage(ListDataLakeNamespacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataLakeNamespacesResponse> nextPage(ListDataLakeNamespacesResponse previousPage) {
            if (previousPage == null) {
                return ListDataLakeNamespacesPublisher.this.client.listDataLakeNamespaces(ListDataLakeNamespacesPublisher.this.firstRequest);
            }
            return ListDataLakeNamespacesPublisher.this.client.listDataLakeNamespaces((ListDataLakeNamespacesRequest)((Object)ListDataLakeNamespacesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

