/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.swf.SwfAsyncClient;
import software.amazon.awssdk.services.swf.SwfServiceClientConfiguration;
import software.amazon.awssdk.services.swf.internal.SwfServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.swf.model.CountClosedWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.CountClosedWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.CountOpenWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.CountOpenWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.CountPendingActivityTasksRequest;
import software.amazon.awssdk.services.swf.model.CountPendingActivityTasksResponse;
import software.amazon.awssdk.services.swf.model.CountPendingDecisionTasksRequest;
import software.amazon.awssdk.services.swf.model.CountPendingDecisionTasksResponse;
import software.amazon.awssdk.services.swf.model.DefaultUndefinedException;
import software.amazon.awssdk.services.swf.model.DeleteActivityTypeRequest;
import software.amazon.awssdk.services.swf.model.DeleteActivityTypeResponse;
import software.amazon.awssdk.services.swf.model.DeleteWorkflowTypeRequest;
import software.amazon.awssdk.services.swf.model.DeleteWorkflowTypeResponse;
import software.amazon.awssdk.services.swf.model.DeprecateActivityTypeRequest;
import software.amazon.awssdk.services.swf.model.DeprecateActivityTypeResponse;
import software.amazon.awssdk.services.swf.model.DeprecateDomainRequest;
import software.amazon.awssdk.services.swf.model.DeprecateDomainResponse;
import software.amazon.awssdk.services.swf.model.DeprecateWorkflowTypeRequest;
import software.amazon.awssdk.services.swf.model.DeprecateWorkflowTypeResponse;
import software.amazon.awssdk.services.swf.model.DescribeActivityTypeRequest;
import software.amazon.awssdk.services.swf.model.DescribeActivityTypeResponse;
import software.amazon.awssdk.services.swf.model.DescribeDomainRequest;
import software.amazon.awssdk.services.swf.model.DescribeDomainResponse;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowTypeRequest;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowTypeResponse;
import software.amazon.awssdk.services.swf.model.DomainAlreadyExistsException;
import software.amazon.awssdk.services.swf.model.DomainDeprecatedException;
import software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryRequest;
import software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryResponse;
import software.amazon.awssdk.services.swf.model.LimitExceededException;
import software.amazon.awssdk.services.swf.model.ListActivityTypesRequest;
import software.amazon.awssdk.services.swf.model.ListActivityTypesResponse;
import software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.ListDomainsRequest;
import software.amazon.awssdk.services.swf.model.ListDomainsResponse;
import software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.swf.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.swf.model.ListWorkflowTypesRequest;
import software.amazon.awssdk.services.swf.model.ListWorkflowTypesResponse;
import software.amazon.awssdk.services.swf.model.OperationNotPermittedException;
import software.amazon.awssdk.services.swf.model.PollForActivityTaskRequest;
import software.amazon.awssdk.services.swf.model.PollForActivityTaskResponse;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskRequest;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse;
import software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatRequest;
import software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatResponse;
import software.amazon.awssdk.services.swf.model.RegisterActivityTypeRequest;
import software.amazon.awssdk.services.swf.model.RegisterActivityTypeResponse;
import software.amazon.awssdk.services.swf.model.RegisterDomainRequest;
import software.amazon.awssdk.services.swf.model.RegisterDomainResponse;
import software.amazon.awssdk.services.swf.model.RegisterWorkflowTypeRequest;
import software.amazon.awssdk.services.swf.model.RegisterWorkflowTypeResponse;
import software.amazon.awssdk.services.swf.model.RequestCancelWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.RequestCancelWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCanceledRequest;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCanceledResponse;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCompletedRequest;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCompletedResponse;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskFailedRequest;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskFailedResponse;
import software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedRequest;
import software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedResponse;
import software.amazon.awssdk.services.swf.model.SignalWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.SignalWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.StartWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.StartWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.SwfException;
import software.amazon.awssdk.services.swf.model.TagResourceRequest;
import software.amazon.awssdk.services.swf.model.TagResourceResponse;
import software.amazon.awssdk.services.swf.model.TerminateWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.TerminateWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.TooManyTagsException;
import software.amazon.awssdk.services.swf.model.TypeAlreadyExistsException;
import software.amazon.awssdk.services.swf.model.TypeDeprecatedException;
import software.amazon.awssdk.services.swf.model.TypeNotDeprecatedException;
import software.amazon.awssdk.services.swf.model.UndeprecateActivityTypeRequest;
import software.amazon.awssdk.services.swf.model.UndeprecateActivityTypeResponse;
import software.amazon.awssdk.services.swf.model.UndeprecateDomainRequest;
import software.amazon.awssdk.services.swf.model.UndeprecateDomainResponse;
import software.amazon.awssdk.services.swf.model.UndeprecateWorkflowTypeRequest;
import software.amazon.awssdk.services.swf.model.UndeprecateWorkflowTypeResponse;
import software.amazon.awssdk.services.swf.model.UnknownResourceException;
import software.amazon.awssdk.services.swf.model.UntagResourceRequest;
import software.amazon.awssdk.services.swf.model.UntagResourceResponse;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionAlreadyStartedException;
import software.amazon.awssdk.services.swf.transform.CountClosedWorkflowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.CountOpenWorkflowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.CountPendingActivityTasksRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.CountPendingDecisionTasksRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DeleteActivityTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DeleteWorkflowTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DeprecateActivityTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DeprecateDomainRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DeprecateWorkflowTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DescribeActivityTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DescribeDomainRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DescribeWorkflowExecutionRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DescribeWorkflowTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.GetWorkflowExecutionHistoryRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.ListActivityTypesRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.ListClosedWorkflowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.ListDomainsRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.ListOpenWorkflowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.ListWorkflowTypesRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.PollForActivityTaskRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.PollForDecisionTaskRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RecordActivityTaskHeartbeatRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RegisterActivityTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RegisterDomainRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RegisterWorkflowTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RequestCancelWorkflowExecutionRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RespondActivityTaskCanceledRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RespondActivityTaskCompletedRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RespondActivityTaskFailedRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RespondDecisionTaskCompletedRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.SignalWorkflowExecutionRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.StartWorkflowExecutionRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.TerminateWorkflowExecutionRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.UndeprecateActivityTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.UndeprecateDomainRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.UndeprecateWorkflowTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultSwfAsyncClient
implements SwfAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSwfAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSwfAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"SWF#2.41.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CountClosedWorkflowExecutionsResponse> countClosedWorkflowExecutions(CountClosedWorkflowExecutionsRequest countClosedWorkflowExecutionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)countClosedWorkflowExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, countClosedWorkflowExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CountClosedWorkflowExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CountClosedWorkflowExecutionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CountClosedWorkflowExecutions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CountClosedWorkflowExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)countClosedWorkflowExecutionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$countClosedWorkflowExecutions$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$countClosedWorkflowExecutions$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CountOpenWorkflowExecutionsResponse> countOpenWorkflowExecutions(CountOpenWorkflowExecutionsRequest countOpenWorkflowExecutionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)countOpenWorkflowExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, countOpenWorkflowExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CountOpenWorkflowExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CountOpenWorkflowExecutionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CountOpenWorkflowExecutions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CountOpenWorkflowExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)countOpenWorkflowExecutionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$countOpenWorkflowExecutions$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$countOpenWorkflowExecutions$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CountPendingActivityTasksResponse> countPendingActivityTasks(CountPendingActivityTasksRequest countPendingActivityTasksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)countPendingActivityTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, countPendingActivityTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CountPendingActivityTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CountPendingActivityTasksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CountPendingActivityTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CountPendingActivityTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)countPendingActivityTasksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$countPendingActivityTasks$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$countPendingActivityTasks$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CountPendingDecisionTasksResponse> countPendingDecisionTasks(CountPendingDecisionTasksRequest countPendingDecisionTasksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)countPendingDecisionTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, countPendingDecisionTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CountPendingDecisionTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CountPendingDecisionTasksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CountPendingDecisionTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CountPendingDecisionTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)countPendingDecisionTasksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$countPendingDecisionTasks$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$countPendingDecisionTasks$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteActivityTypeResponse> deleteActivityType(DeleteActivityTypeRequest deleteActivityTypeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteActivityTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, deleteActivityTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteActivityType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteActivityTypeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteActivityType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteActivityTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteActivityTypeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$deleteActivityType$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$deleteActivityType$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteWorkflowTypeResponse> deleteWorkflowType(DeleteWorkflowTypeRequest deleteWorkflowTypeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteWorkflowTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, deleteWorkflowTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWorkflowType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkflowTypeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkflowType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteWorkflowTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteWorkflowTypeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$deleteWorkflowType$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$deleteWorkflowType$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeprecateActivityTypeResponse> deprecateActivityType(DeprecateActivityTypeRequest deprecateActivityTypeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deprecateActivityTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, deprecateActivityTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeprecateActivityType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeprecateActivityTypeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeprecateActivityType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeprecateActivityTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deprecateActivityTypeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$deprecateActivityType$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$deprecateActivityType$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeprecateDomainResponse> deprecateDomain(DeprecateDomainRequest deprecateDomainRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deprecateDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, deprecateDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeprecateDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeprecateDomainResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeprecateDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeprecateDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deprecateDomainRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$deprecateDomain$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$deprecateDomain$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeprecateWorkflowTypeResponse> deprecateWorkflowType(DeprecateWorkflowTypeRequest deprecateWorkflowTypeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deprecateWorkflowTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, deprecateWorkflowTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeprecateWorkflowType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeprecateWorkflowTypeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeprecateWorkflowType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeprecateWorkflowTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deprecateWorkflowTypeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$deprecateWorkflowType$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$deprecateWorkflowType$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeActivityTypeResponse> describeActivityType(DescribeActivityTypeRequest describeActivityTypeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeActivityTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, describeActivityTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeActivityType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeActivityTypeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeActivityType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeActivityTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeActivityTypeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$describeActivityType$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$describeActivityType$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDomainResponse> describeDomain(DescribeDomainRequest describeDomainRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, describeDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDomainResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDomainRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$describeDomain$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$describeDomain$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeWorkflowExecutionResponse> describeWorkflowExecution(DescribeWorkflowExecutionRequest describeWorkflowExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeWorkflowExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, describeWorkflowExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWorkflowExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkflowExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkflowExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeWorkflowExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeWorkflowExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$describeWorkflowExecution$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$describeWorkflowExecution$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeWorkflowTypeResponse> describeWorkflowType(DescribeWorkflowTypeRequest describeWorkflowTypeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeWorkflowTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, describeWorkflowTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWorkflowType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkflowTypeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkflowType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeWorkflowTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeWorkflowTypeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$describeWorkflowType$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$describeWorkflowType$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetWorkflowExecutionHistoryResponse> getWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest getWorkflowExecutionHistoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getWorkflowExecutionHistoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, getWorkflowExecutionHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkflowExecutionHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkflowExecutionHistoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkflowExecutionHistory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetWorkflowExecutionHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getWorkflowExecutionHistoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$getWorkflowExecutionHistory$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$getWorkflowExecutionHistory$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListActivityTypesResponse> listActivityTypes(ListActivityTypesRequest listActivityTypesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listActivityTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, listActivityTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListActivityTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListActivityTypesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListActivityTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListActivityTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listActivityTypesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$listActivityTypes$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$listActivityTypes$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListClosedWorkflowExecutionsResponse> listClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest listClosedWorkflowExecutionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listClosedWorkflowExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, listClosedWorkflowExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListClosedWorkflowExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListClosedWorkflowExecutionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListClosedWorkflowExecutions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListClosedWorkflowExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listClosedWorkflowExecutionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$listClosedWorkflowExecutions$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$listClosedWorkflowExecutions$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDomainsResponse> listDomains(ListDomainsRequest listDomainsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDomainsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, listDomainsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDomains");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomains").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDomainsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDomainsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$listDomains$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$listDomains$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListOpenWorkflowExecutionsResponse> listOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest listOpenWorkflowExecutionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listOpenWorkflowExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, listOpenWorkflowExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOpenWorkflowExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOpenWorkflowExecutionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOpenWorkflowExecutions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListOpenWorkflowExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listOpenWorkflowExecutionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$listOpenWorkflowExecutions$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$listOpenWorkflowExecutions$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$listTagsForResource$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$listTagsForResource$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListWorkflowTypesResponse> listWorkflowTypes(ListWorkflowTypesRequest listWorkflowTypesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listWorkflowTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, listWorkflowTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorkflowTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkflowTypesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkflowTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListWorkflowTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listWorkflowTypesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$listWorkflowTypes$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$listWorkflowTypes$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PollForActivityTaskResponse> pollForActivityTask(PollForActivityTaskRequest pollForActivityTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)pollForActivityTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, pollForActivityTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PollForActivityTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PollForActivityTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PollForActivityTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PollForActivityTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)pollForActivityTaskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$pollForActivityTask$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$pollForActivityTask$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PollForDecisionTaskResponse> pollForDecisionTask(PollForDecisionTaskRequest pollForDecisionTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)pollForDecisionTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, pollForDecisionTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PollForDecisionTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PollForDecisionTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PollForDecisionTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PollForDecisionTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)pollForDecisionTaskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$pollForDecisionTask$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$pollForDecisionTask$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RecordActivityTaskHeartbeatResponse> recordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest recordActivityTaskHeartbeatRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)recordActivityTaskHeartbeatRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, recordActivityTaskHeartbeatRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RecordActivityTaskHeartbeat");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RecordActivityTaskHeartbeatResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RecordActivityTaskHeartbeat").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RecordActivityTaskHeartbeatRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)recordActivityTaskHeartbeatRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$recordActivityTaskHeartbeat$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$recordActivityTaskHeartbeat$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterActivityTypeResponse> registerActivityType(RegisterActivityTypeRequest registerActivityTypeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerActivityTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, registerActivityTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterActivityType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterActivityTypeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterActivityType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RegisterActivityTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerActivityTypeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$registerActivityType$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$registerActivityType$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterDomainResponse> registerDomain(RegisterDomainRequest registerDomainRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, registerDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterDomainResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RegisterDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerDomainRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$registerDomain$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$registerDomain$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterWorkflowTypeResponse> registerWorkflowType(RegisterWorkflowTypeRequest registerWorkflowTypeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerWorkflowTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, registerWorkflowTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterWorkflowType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterWorkflowTypeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterWorkflowType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RegisterWorkflowTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerWorkflowTypeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$registerWorkflowType$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$registerWorkflowType$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RequestCancelWorkflowExecutionResponse> requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest requestCancelWorkflowExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)requestCancelWorkflowExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, requestCancelWorkflowExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RequestCancelWorkflowExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RequestCancelWorkflowExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RequestCancelWorkflowExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RequestCancelWorkflowExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)requestCancelWorkflowExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$requestCancelWorkflowExecution$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$requestCancelWorkflowExecution$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RespondActivityTaskCanceledResponse> respondActivityTaskCanceled(RespondActivityTaskCanceledRequest respondActivityTaskCanceledRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)respondActivityTaskCanceledRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, respondActivityTaskCanceledRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RespondActivityTaskCanceled");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RespondActivityTaskCanceledResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RespondActivityTaskCanceled").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RespondActivityTaskCanceledRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)respondActivityTaskCanceledRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$respondActivityTaskCanceled$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$respondActivityTaskCanceled$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RespondActivityTaskCompletedResponse> respondActivityTaskCompleted(RespondActivityTaskCompletedRequest respondActivityTaskCompletedRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)respondActivityTaskCompletedRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, respondActivityTaskCompletedRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RespondActivityTaskCompleted");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RespondActivityTaskCompletedResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RespondActivityTaskCompleted").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RespondActivityTaskCompletedRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)respondActivityTaskCompletedRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$respondActivityTaskCompleted$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$respondActivityTaskCompleted$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RespondActivityTaskFailedResponse> respondActivityTaskFailed(RespondActivityTaskFailedRequest respondActivityTaskFailedRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)respondActivityTaskFailedRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, respondActivityTaskFailedRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RespondActivityTaskFailed");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RespondActivityTaskFailedResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RespondActivityTaskFailed").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RespondActivityTaskFailedRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)respondActivityTaskFailedRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$respondActivityTaskFailed$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$respondActivityTaskFailed$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RespondDecisionTaskCompletedResponse> respondDecisionTaskCompleted(RespondDecisionTaskCompletedRequest respondDecisionTaskCompletedRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)respondDecisionTaskCompletedRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, respondDecisionTaskCompletedRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RespondDecisionTaskCompleted");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RespondDecisionTaskCompletedResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RespondDecisionTaskCompleted").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RespondDecisionTaskCompletedRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)respondDecisionTaskCompletedRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$respondDecisionTaskCompleted$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$respondDecisionTaskCompleted$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SignalWorkflowExecutionResponse> signalWorkflowExecution(SignalWorkflowExecutionRequest signalWorkflowExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)signalWorkflowExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, signalWorkflowExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SignalWorkflowExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SignalWorkflowExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SignalWorkflowExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SignalWorkflowExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)signalWorkflowExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$signalWorkflowExecution$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$signalWorkflowExecution$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartWorkflowExecutionResponse> startWorkflowExecution(StartWorkflowExecutionRequest startWorkflowExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startWorkflowExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, startWorkflowExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartWorkflowExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartWorkflowExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartWorkflowExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartWorkflowExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startWorkflowExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$startWorkflowExecution$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$startWorkflowExecution$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$tagResource$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$tagResource$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TerminateWorkflowExecutionResponse> terminateWorkflowExecution(TerminateWorkflowExecutionRequest terminateWorkflowExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)terminateWorkflowExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, terminateWorkflowExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TerminateWorkflowExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TerminateWorkflowExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateWorkflowExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TerminateWorkflowExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)terminateWorkflowExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$terminateWorkflowExecution$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$terminateWorkflowExecution$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UndeprecateActivityTypeResponse> undeprecateActivityType(UndeprecateActivityTypeRequest undeprecateActivityTypeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)undeprecateActivityTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, undeprecateActivityTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UndeprecateActivityType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UndeprecateActivityTypeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UndeprecateActivityType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UndeprecateActivityTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)undeprecateActivityTypeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$undeprecateActivityType$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$undeprecateActivityType$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UndeprecateDomainResponse> undeprecateDomain(UndeprecateDomainRequest undeprecateDomainRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)undeprecateDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, undeprecateDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UndeprecateDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UndeprecateDomainResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UndeprecateDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UndeprecateDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)undeprecateDomainRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$undeprecateDomain$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$undeprecateDomain$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UndeprecateWorkflowTypeResponse> undeprecateWorkflowType(UndeprecateWorkflowTypeRequest undeprecateWorkflowTypeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)undeprecateWorkflowTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, undeprecateWorkflowTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UndeprecateWorkflowType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UndeprecateWorkflowTypeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UndeprecateWorkflowType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UndeprecateWorkflowTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)undeprecateWorkflowTypeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$undeprecateWorkflowType$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$undeprecateWorkflowType$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSwfAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SWF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TypeNotDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotDeprecatedException::builder).build());
                    }
                    case "TypeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build());
                    }
                    case "TypeDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeDeprecatedException::builder).build());
                    }
                    case "LimitExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "DomainDeprecatedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainDeprecatedException::builder).build());
                    }
                    case "DefaultUndefinedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUndefinedException::builder).build());
                    }
                    case "DomainAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build());
                    }
                    case "OperationNotPermittedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "WorkflowExecutionAlreadyStartedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build());
                    }
                    case "TooManyTagsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "UnknownResourceFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSwfAsyncClient.lambda$untagResource$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSwfAsyncClient.lambda$untagResource$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final SwfServiceClientConfiguration serviceClientConfiguration() {
        return new SwfServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "swf";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SwfException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        SwfServiceClientConfigurationBuilder serviceConfigBuilder = new SwfServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$untagResource$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$154(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$undeprecateWorkflowType$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$undeprecateWorkflowType$150(List metricPublishers, MetricCollector apiCallMetricCollector, UndeprecateWorkflowTypeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$undeprecateDomain$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$undeprecateDomain$146(List metricPublishers, MetricCollector apiCallMetricCollector, UndeprecateDomainResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$undeprecateActivityType$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$undeprecateActivityType$142(List metricPublishers, MetricCollector apiCallMetricCollector, UndeprecateActivityTypeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$terminateWorkflowExecution$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$terminateWorkflowExecution$138(List metricPublishers, MetricCollector apiCallMetricCollector, TerminateWorkflowExecutionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$134(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startWorkflowExecution$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startWorkflowExecution$130(List metricPublishers, MetricCollector apiCallMetricCollector, StartWorkflowExecutionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$signalWorkflowExecution$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$signalWorkflowExecution$126(List metricPublishers, MetricCollector apiCallMetricCollector, SignalWorkflowExecutionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$respondDecisionTaskCompleted$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$respondDecisionTaskCompleted$122(List metricPublishers, MetricCollector apiCallMetricCollector, RespondDecisionTaskCompletedResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$respondActivityTaskFailed$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$respondActivityTaskFailed$118(List metricPublishers, MetricCollector apiCallMetricCollector, RespondActivityTaskFailedResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$respondActivityTaskCompleted$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$respondActivityTaskCompleted$114(List metricPublishers, MetricCollector apiCallMetricCollector, RespondActivityTaskCompletedResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$respondActivityTaskCanceled$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$respondActivityTaskCanceled$110(List metricPublishers, MetricCollector apiCallMetricCollector, RespondActivityTaskCanceledResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$requestCancelWorkflowExecution$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$requestCancelWorkflowExecution$106(List metricPublishers, MetricCollector apiCallMetricCollector, RequestCancelWorkflowExecutionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$registerWorkflowType$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerWorkflowType$102(List metricPublishers, MetricCollector apiCallMetricCollector, RegisterWorkflowTypeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$registerDomain$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerDomain$98(List metricPublishers, MetricCollector apiCallMetricCollector, RegisterDomainResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$registerActivityType$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerActivityType$94(List metricPublishers, MetricCollector apiCallMetricCollector, RegisterActivityTypeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$recordActivityTaskHeartbeat$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$recordActivityTaskHeartbeat$90(List metricPublishers, MetricCollector apiCallMetricCollector, RecordActivityTaskHeartbeatResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$pollForDecisionTask$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$pollForDecisionTask$86(List metricPublishers, MetricCollector apiCallMetricCollector, PollForDecisionTaskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$pollForActivityTask$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$pollForActivityTask$82(List metricPublishers, MetricCollector apiCallMetricCollector, PollForActivityTaskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listWorkflowTypes$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorkflowTypes$78(List metricPublishers, MetricCollector apiCallMetricCollector, ListWorkflowTypesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$74(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listOpenWorkflowExecutions$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOpenWorkflowExecutions$70(List metricPublishers, MetricCollector apiCallMetricCollector, ListOpenWorkflowExecutionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDomains$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDomains$66(List metricPublishers, MetricCollector apiCallMetricCollector, ListDomainsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listClosedWorkflowExecutions$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listClosedWorkflowExecutions$62(List metricPublishers, MetricCollector apiCallMetricCollector, ListClosedWorkflowExecutionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listActivityTypes$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listActivityTypes$58(List metricPublishers, MetricCollector apiCallMetricCollector, ListActivityTypesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getWorkflowExecutionHistory$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkflowExecutionHistory$54(List metricPublishers, MetricCollector apiCallMetricCollector, GetWorkflowExecutionHistoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeWorkflowType$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWorkflowType$50(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeWorkflowTypeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeWorkflowExecution$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWorkflowExecution$46(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeWorkflowExecutionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDomain$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDomain$42(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDomainResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeActivityType$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeActivityType$38(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeActivityTypeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deprecateWorkflowType$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deprecateWorkflowType$34(List metricPublishers, MetricCollector apiCallMetricCollector, DeprecateWorkflowTypeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deprecateDomain$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deprecateDomain$30(List metricPublishers, MetricCollector apiCallMetricCollector, DeprecateDomainResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deprecateActivityType$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deprecateActivityType$26(List metricPublishers, MetricCollector apiCallMetricCollector, DeprecateActivityTypeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteWorkflowType$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWorkflowType$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteWorkflowTypeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteActivityType$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteActivityType$18(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteActivityTypeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$countPendingDecisionTasks$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$countPendingDecisionTasks$14(List metricPublishers, MetricCollector apiCallMetricCollector, CountPendingDecisionTasksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$countPendingActivityTasks$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$countPendingActivityTasks$10(List metricPublishers, MetricCollector apiCallMetricCollector, CountPendingActivityTasksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$countOpenWorkflowExecutions$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$countOpenWorkflowExecutions$6(List metricPublishers, MetricCollector apiCallMetricCollector, CountOpenWorkflowExecutionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$countClosedWorkflowExecutions$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$countClosedWorkflowExecutions$2(List metricPublishers, MetricCollector apiCallMetricCollector, CountClosedWorkflowExecutionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

