/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.textract.TextractAsyncClient;
import software.amazon.awssdk.services.textract.internal.UserAgentUtils;
import software.amazon.awssdk.services.textract.model.AdapterVersionOverview;
import software.amazon.awssdk.services.textract.model.ListAdapterVersionsRequest;
import software.amazon.awssdk.services.textract.model.ListAdapterVersionsResponse;

public class ListAdapterVersionsPublisher
implements SdkPublisher<ListAdapterVersionsResponse> {
    private final TextractAsyncClient client;
    private final ListAdapterVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAdapterVersionsPublisher(TextractAsyncClient client, ListAdapterVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAdapterVersionsPublisher(TextractAsyncClient client, ListAdapterVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAdapterVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAdapterVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AdapterVersionOverview> adapterVersions() {
        return this.flatMapIterable(response -> response.adapterVersions());
    }

    private class ListAdapterVersionsResponseFetcher
    implements AsyncPageFetcher<ListAdapterVersionsResponse> {
        private ListAdapterVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAdapterVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAdapterVersionsResponse> nextPage(ListAdapterVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListAdapterVersionsPublisher.this.client.listAdapterVersions(ListAdapterVersionsPublisher.this.firstRequest);
            }
            return ListAdapterVersionsPublisher.this.client.listAdapterVersions((ListAdapterVersionsRequest)((Object)ListAdapterVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

