/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.timestreaminfluxdb.model.RebootDbClusterInputInstanceIdsListCopier;
import software.amazon.awssdk.services.timestreaminfluxdb.model.TimestreamInfluxDbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RebootDbClusterRequest
extends TimestreamInfluxDbRequest
implements ToCopyableBuilder<Builder, RebootDbClusterRequest> {
    private static final SdkField<String> DB_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbClusterId").getter(RebootDbClusterRequest.getter(RebootDbClusterRequest::dbClusterId)).setter(RebootDbClusterRequest.setter(Builder::dbClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbClusterId").build()}).build();
    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceIds").getter(RebootDbClusterRequest.getter(RebootDbClusterRequest::instanceIds)).setter(RebootDbClusterRequest.setter(Builder::instanceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_ID_FIELD, INSTANCE_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RebootDbClusterRequest.memberNameToFieldInitializer();
    private final String dbClusterId;
    private final List<String> instanceIds;

    private RebootDbClusterRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterId = builder.dbClusterId;
        this.instanceIds = builder.instanceIds;
    }

    public final String dbClusterId() {
        return this.dbClusterId;
    }

    public final boolean hasInstanceIds() {
        return this.instanceIds != null && !(this.instanceIds instanceof SdkAutoConstructList);
    }

    public final List<String> instanceIds() {
        return this.instanceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceIds() ? this.instanceIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebootDbClusterRequest)) {
            return false;
        }
        RebootDbClusterRequest other = (RebootDbClusterRequest)((Object)obj);
        return Objects.equals(this.dbClusterId(), other.dbClusterId()) && this.hasInstanceIds() == other.hasInstanceIds() && Objects.equals(this.instanceIds(), other.instanceIds());
    }

    public final String toString() {
        return ToString.builder((String)"RebootDbClusterRequest").add("DbClusterId", (Object)this.dbClusterId()).add("InstanceIds", this.hasInstanceIds() ? this.instanceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dbClusterId": {
                return Optional.ofNullable(clazz.cast(this.dbClusterId()));
            }
            case "instanceIds": {
                return Optional.ofNullable(clazz.cast(this.instanceIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dbClusterId", DB_CLUSTER_ID_FIELD);
        map.put("instanceIds", INSTANCE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RebootDbClusterRequest, T> g) {
        return obj -> g.apply((RebootDbClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamInfluxDbRequest.BuilderImpl
    implements Builder {
        private String dbClusterId;
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RebootDbClusterRequest model) {
            super(model);
            this.dbClusterId(model.dbClusterId);
            this.instanceIds(model.instanceIds);
        }

        public final String getDbClusterId() {
            return this.dbClusterId;
        }

        public final void setDbClusterId(String dbClusterId) {
            this.dbClusterId = dbClusterId;
        }

        @Override
        public final Builder dbClusterId(String dbClusterId) {
            this.dbClusterId = dbClusterId;
            return this;
        }

        public final Collection<String> getInstanceIds() {
            if (this.instanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceIds;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = RebootDbClusterInputInstanceIdsListCopier.copy(instanceIds);
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = RebootDbClusterInputInstanceIdsListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RebootDbClusterRequest build() {
            return new RebootDbClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TimestreamInfluxDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RebootDbClusterRequest> {
        public Builder dbClusterId(String var1);

        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

