/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountSettingsResponse extends TimestreamQueryResponse implements
        ToCopyableBuilder<DescribeAccountSettingsResponse.Builder, DescribeAccountSettingsResponse> {
    private static final SdkField<Integer> MAX_QUERY_TCU_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxQueryTCU").getter(getter(DescribeAccountSettingsResponse::maxQueryTCU))
            .setter(setter(Builder::maxQueryTCU))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxQueryTCU").build()).build();

    private static final SdkField<String> QUERY_PRICING_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryPricingModel").getter(getter(DescribeAccountSettingsResponse::queryPricingModelAsString))
            .setter(setter(Builder::queryPricingModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryPricingModel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_QUERY_TCU_FIELD,
            QUERY_PRICING_MODEL_FIELD));

    private final Integer maxQueryTCU;

    private final String queryPricingModel;

    private DescribeAccountSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.maxQueryTCU = builder.maxQueryTCU;
        this.queryPricingModel = builder.queryPricingModel;
    }

    /**
     * <p>
     * The maximum number of <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/tcu.html">Timestream
     * compute units</a> (TCUs) the service will use at any point in time to serve your queries.
     * </p>
     * 
     * @return The maximum number of <a
     *         href="https://docs.aws.amazon.com/timestream/latest/developerguide/tcu.html">Timestream compute units</a>
     *         (TCUs) the service will use at any point in time to serve your queries.
     */
    public final Integer maxQueryTCU() {
        return maxQueryTCU;
    }

    /**
     * <p>
     * The pricing model for queries in your account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryPricingModel}
     * will return {@link QueryPricingModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #queryPricingModelAsString}.
     * </p>
     * 
     * @return The pricing model for queries in your account.
     * @see QueryPricingModel
     */
    public final QueryPricingModel queryPricingModel() {
        return QueryPricingModel.fromValue(queryPricingModel);
    }

    /**
     * <p>
     * The pricing model for queries in your account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryPricingModel}
     * will return {@link QueryPricingModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #queryPricingModelAsString}.
     * </p>
     * 
     * @return The pricing model for queries in your account.
     * @see QueryPricingModel
     */
    public final String queryPricingModelAsString() {
        return queryPricingModel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxQueryTCU());
        hashCode = 31 * hashCode + Objects.hashCode(queryPricingModelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountSettingsResponse)) {
            return false;
        }
        DescribeAccountSettingsResponse other = (DescribeAccountSettingsResponse) obj;
        return Objects.equals(maxQueryTCU(), other.maxQueryTCU())
                && Objects.equals(queryPricingModelAsString(), other.queryPricingModelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountSettingsResponse").add("MaxQueryTCU", maxQueryTCU())
                .add("QueryPricingModel", queryPricingModelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxQueryTCU":
            return Optional.ofNullable(clazz.cast(maxQueryTCU()));
        case "QueryPricingModel":
            return Optional.ofNullable(clazz.cast(queryPricingModelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountSettingsResponse, T> g) {
        return obj -> g.apply((DescribeAccountSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TimestreamQueryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAccountSettingsResponse> {
        /**
         * <p>
         * The maximum number of <a
         * href="https://docs.aws.amazon.com/timestream/latest/developerguide/tcu.html">Timestream compute units</a>
         * (TCUs) the service will use at any point in time to serve your queries.
         * </p>
         * 
         * @param maxQueryTCU
         *        The maximum number of <a
         *        href="https://docs.aws.amazon.com/timestream/latest/developerguide/tcu.html">Timestream compute
         *        units</a> (TCUs) the service will use at any point in time to serve your queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxQueryTCU(Integer maxQueryTCU);

        /**
         * <p>
         * The pricing model for queries in your account.
         * </p>
         * 
         * @param queryPricingModel
         *        The pricing model for queries in your account.
         * @see QueryPricingModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryPricingModel
         */
        Builder queryPricingModel(String queryPricingModel);

        /**
         * <p>
         * The pricing model for queries in your account.
         * </p>
         * 
         * @param queryPricingModel
         *        The pricing model for queries in your account.
         * @see QueryPricingModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryPricingModel
         */
        Builder queryPricingModel(QueryPricingModel queryPricingModel);
    }

    static final class BuilderImpl extends TimestreamQueryResponse.BuilderImpl implements Builder {
        private Integer maxQueryTCU;

        private String queryPricingModel;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountSettingsResponse model) {
            super(model);
            maxQueryTCU(model.maxQueryTCU);
            queryPricingModel(model.queryPricingModel);
        }

        public final Integer getMaxQueryTCU() {
            return maxQueryTCU;
        }

        public final void setMaxQueryTCU(Integer maxQueryTCU) {
            this.maxQueryTCU = maxQueryTCU;
        }

        @Override
        public final Builder maxQueryTCU(Integer maxQueryTCU) {
            this.maxQueryTCU = maxQueryTCU;
            return this;
        }

        public final String getQueryPricingModel() {
            return queryPricingModel;
        }

        public final void setQueryPricingModel(String queryPricingModel) {
            this.queryPricingModel = queryPricingModel;
        }

        @Override
        public final Builder queryPricingModel(String queryPricingModel) {
            this.queryPricingModel = queryPricingModel;
            return this;
        }

        @Override
        public final Builder queryPricingModel(QueryPricingModel queryPricingModel) {
            this.queryPricingModel(queryPricingModel == null ? null : queryPricingModel.toString());
            return this;
        }

        @Override
        public DescribeAccountSettingsResponse build() {
            return new DescribeAccountSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
