/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.ClientEndpointProvider;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRefreshCache;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryAsyncClient;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryAsyncEndpointDiscoveryCacheLoader;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryServiceClientConfiguration;
import software.amazon.awssdk.services.timestreamquery.internal.TimestreamQueryServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.timestreamquery.model.AccessDeniedException;
import software.amazon.awssdk.services.timestreamquery.model.CancelQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.CancelQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ConflictException;
import software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.DeleteScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.DeleteScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.DescribeAccountSettingsRequest;
import software.amazon.awssdk.services.timestreamquery.model.DescribeAccountSettingsResponse;
import software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ExecuteScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.ExecuteScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.InternalServerException;
import software.amazon.awssdk.services.timestreamquery.model.InvalidEndpointException;
import software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesRequest;
import software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesResponse;
import software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.timestreamquery.model.PrepareQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.PrepareQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.QueryExecutionException;
import software.amazon.awssdk.services.timestreamquery.model.QueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.QueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ResourceNotFoundException;
import software.amazon.awssdk.services.timestreamquery.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.timestreamquery.model.TagResourceRequest;
import software.amazon.awssdk.services.timestreamquery.model.TagResourceResponse;
import software.amazon.awssdk.services.timestreamquery.model.ThrottlingException;
import software.amazon.awssdk.services.timestreamquery.model.TimestreamQueryException;
import software.amazon.awssdk.services.timestreamquery.model.UntagResourceRequest;
import software.amazon.awssdk.services.timestreamquery.model.UntagResourceResponse;
import software.amazon.awssdk.services.timestreamquery.model.UpdateAccountSettingsRequest;
import software.amazon.awssdk.services.timestreamquery.model.UpdateAccountSettingsResponse;
import software.amazon.awssdk.services.timestreamquery.model.UpdateScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.UpdateScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ValidationException;
import software.amazon.awssdk.services.timestreamquery.transform.CancelQueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.CreateScheduledQueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.DeleteScheduledQueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.DescribeAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.DescribeEndpointsRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.DescribeScheduledQueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.ExecuteScheduledQueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.ListScheduledQueriesRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.PrepareQueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.QueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.UpdateAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.UpdateScheduledQueryRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultTimestreamQueryAsyncClient
implements TimestreamQueryAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultTimestreamQueryAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private EndpointDiscoveryRefreshCache endpointDiscoveryCache;

    protected DefaultTimestreamQueryAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Timestream_Query#2.41.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        if (((Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED)).booleanValue()) {
            this.endpointDiscoveryCache = EndpointDiscoveryRefreshCache.create((EndpointDiscoveryCacheLoader)TimestreamQueryAsyncEndpointDiscoveryCacheLoader.create(this));
            if (((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden()) {
                log.warn("Endpoint discovery is enabled for this client, and an endpoint override was also specified. This will disable endpoint discovery for methods that require it, instead using the specified endpoint override. This may or may not be what you intended.");
            }
        }
    }

    @Override
    public CompletableFuture<CancelQueryResponse> cancelQuery(CancelQueryRequest cancelQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamQueryAsyncClient.resolveMetricPublishers(clientConfiguration, cancelQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEndpointException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "QueryExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = cancelQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)cancelQueryRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$cancelQuery$3(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, cancelQueryRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamQueryAsyncClient.lambda$cancelQuery$5(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryAsyncClient.lambda$cancelQuery$6((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateScheduledQueryResponse> createScheduledQuery(CreateScheduledQueryRequest createScheduledQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createScheduledQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamQueryAsyncClient.resolveMetricPublishers(clientConfiguration, createScheduledQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateScheduledQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateScheduledQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEndpointException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "QueryExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = createScheduledQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)createScheduledQueryRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$createScheduledQuery$10(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, createScheduledQueryRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamQueryAsyncClient.lambda$createScheduledQuery$12(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryAsyncClient.lambda$createScheduledQuery$13((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteScheduledQueryResponse> deleteScheduledQuery(DeleteScheduledQueryRequest deleteScheduledQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteScheduledQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamQueryAsyncClient.resolveMetricPublishers(clientConfiguration, deleteScheduledQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteScheduledQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteScheduledQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEndpointException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "QueryExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = deleteScheduledQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)deleteScheduledQueryRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$deleteScheduledQuery$17(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, deleteScheduledQueryRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamQueryAsyncClient.lambda$deleteScheduledQuery$19(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryAsyncClient.lambda$deleteScheduledQuery$20((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAccountSettingsResponse> describeAccountSettings(DescribeAccountSettingsRequest describeAccountSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAccountSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamQueryAsyncClient.resolveMetricPublishers(clientConfiguration, describeAccountSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccountSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEndpointException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "QueryExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = describeAccountSettingsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeAccountSettingsRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$describeAccountSettings$24(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, describeAccountSettingsRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamQueryAsyncClient.lambda$describeAccountSettings$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryAsyncClient.lambda$describeAccountSettings$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEndpointsResponse> describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamQueryAsyncClient.resolveMetricPublishers(clientConfiguration, describeEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEndpointException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "QueryExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEndpointsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTimestreamQueryAsyncClient.lambda$describeEndpoints$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryAsyncClient.lambda$describeEndpoints$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeScheduledQueryResponse> describeScheduledQuery(DescribeScheduledQueryRequest describeScheduledQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeScheduledQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamQueryAsyncClient.resolveMetricPublishers(clientConfiguration, describeScheduledQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScheduledQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeScheduledQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEndpointException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "QueryExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = describeScheduledQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeScheduledQueryRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$describeScheduledQuery$35(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, describeScheduledQueryRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamQueryAsyncClient.lambda$describeScheduledQuery$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryAsyncClient.lambda$describeScheduledQuery$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ExecuteScheduledQueryResponse> executeScheduledQuery(ExecuteScheduledQueryRequest executeScheduledQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)executeScheduledQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamQueryAsyncClient.resolveMetricPublishers(clientConfiguration, executeScheduledQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteScheduledQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteScheduledQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEndpointException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "QueryExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = executeScheduledQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)executeScheduledQueryRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$executeScheduledQuery$42(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, executeScheduledQueryRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamQueryAsyncClient.lambda$executeScheduledQuery$44(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryAsyncClient.lambda$executeScheduledQuery$45((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListScheduledQueriesResponse> listScheduledQueries(ListScheduledQueriesRequest listScheduledQueriesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listScheduledQueriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamQueryAsyncClient.resolveMetricPublishers(clientConfiguration, listScheduledQueriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListScheduledQueries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListScheduledQueriesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEndpointException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "QueryExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = listScheduledQueriesRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)listScheduledQueriesRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$listScheduledQueries$49(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, listScheduledQueriesRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamQueryAsyncClient.lambda$listScheduledQueries$51(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryAsyncClient.lambda$listScheduledQueries$52((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamQueryAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEndpointException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "QueryExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = listTagsForResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)listTagsForResourceRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$listTagsForResource$56(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, listTagsForResourceRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamQueryAsyncClient.lambda$listTagsForResource$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryAsyncClient.lambda$listTagsForResource$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PrepareQueryResponse> prepareQuery(PrepareQueryRequest prepareQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)prepareQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamQueryAsyncClient.resolveMetricPublishers(clientConfiguration, prepareQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PrepareQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PrepareQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEndpointException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "QueryExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = prepareQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)prepareQueryRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$prepareQuery$63(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, prepareQueryRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamQueryAsyncClient.lambda$prepareQuery$65(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryAsyncClient.lambda$prepareQuery$66((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<QueryResponse> query(QueryRequest queryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)queryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamQueryAsyncClient.resolveMetricPublishers(clientConfiguration, queryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Query");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, QueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEndpointException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "QueryExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = queryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)queryRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$query$70(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, queryRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamQueryAsyncClient.lambda$query$72(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryAsyncClient.lambda$query$73((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamQueryAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEndpointException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "QueryExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = tagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)tagResourceRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$tagResource$77(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, tagResourceRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamQueryAsyncClient.lambda$tagResource$79(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryAsyncClient.lambda$tagResource$80((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamQueryAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEndpointException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "QueryExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = untagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)untagResourceRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$untagResource$84(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, untagResourceRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamQueryAsyncClient.lambda$untagResource$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryAsyncClient.lambda$untagResource$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateAccountSettingsResponse> updateAccountSettings(UpdateAccountSettingsRequest updateAccountSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAccountSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamQueryAsyncClient.resolveMetricPublishers(clientConfiguration, updateAccountSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAccountSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAccountSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEndpointException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "QueryExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = updateAccountSettingsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)updateAccountSettingsRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$updateAccountSettings$91(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, updateAccountSettingsRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamQueryAsyncClient.lambda$updateAccountSettings$93(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryAsyncClient.lambda$updateAccountSettings$94((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateScheduledQueryResponse> updateScheduledQuery(UpdateScheduledQueryRequest updateScheduledQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateScheduledQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamQueryAsyncClient.resolveMetricPublishers(clientConfiguration, updateScheduledQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateScheduledQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateScheduledQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEndpointException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "QueryExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = updateScheduledQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)updateScheduledQueryRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$updateScheduledQuery$98(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, updateScheduledQueryRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamQueryAsyncClient.lambda$updateScheduledQuery$100(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryAsyncClient.lambda$updateScheduledQuery$101((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final TimestreamQueryServiceClientConfiguration serviceClientConfiguration() {
        return new TimestreamQueryServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "timestream";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(TimestreamQueryException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        TimestreamQueryServiceClientConfigurationBuilder serviceConfigBuilder = new TimestreamQueryServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateScheduledQuery$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateScheduledQuery$100(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateScheduledQueryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$updateScheduledQuery$98(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, UpdateScheduledQueryRequest updateScheduledQueryRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateScheduledQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateScheduledQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateScheduledQueryRequest));
    }

    private static /* synthetic */ void lambda$updateAccountSettings$94(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAccountSettings$93(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateAccountSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$updateAccountSettings$91(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, UpdateAccountSettingsRequest updateAccountSettingsRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAccountSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateAccountSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateAccountSettingsRequest));
    }

    private static /* synthetic */ void lambda$untagResource$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$86(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$untagResource$84(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, UntagResourceRequest untagResourceRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)untagResourceRequest));
    }

    private static /* synthetic */ void lambda$tagResource$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$79(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$tagResource$77(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, TagResourceRequest tagResourceRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)tagResourceRequest));
    }

    private static /* synthetic */ void lambda$query$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$query$72(List metricPublishers, MetricCollector apiCallMetricCollector, QueryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$query$70(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, QueryRequest queryRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("Query").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new QueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)queryRequest));
    }

    private static /* synthetic */ void lambda$prepareQuery$66(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$prepareQuery$65(List metricPublishers, MetricCollector apiCallMetricCollector, PrepareQueryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$prepareQuery$63(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, PrepareQueryRequest prepareQueryRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("PrepareQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PrepareQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)prepareQueryRequest));
    }

    private static /* synthetic */ void lambda$listTagsForResource$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$58(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$listTagsForResource$56(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, ListTagsForResourceRequest listTagsForResourceRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listTagsForResourceRequest));
    }

    private static /* synthetic */ void lambda$listScheduledQueries$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listScheduledQueries$51(List metricPublishers, MetricCollector apiCallMetricCollector, ListScheduledQueriesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$listScheduledQueries$49(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, ListScheduledQueriesRequest listScheduledQueriesRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListScheduledQueries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListScheduledQueriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listScheduledQueriesRequest));
    }

    private static /* synthetic */ void lambda$executeScheduledQuery$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeScheduledQuery$44(List metricPublishers, MetricCollector apiCallMetricCollector, ExecuteScheduledQueryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$executeScheduledQuery$42(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, ExecuteScheduledQueryRequest executeScheduledQueryRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteScheduledQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ExecuteScheduledQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)executeScheduledQueryRequest));
    }

    private static /* synthetic */ void lambda$describeScheduledQuery$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeScheduledQuery$37(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeScheduledQueryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$describeScheduledQuery$35(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DescribeScheduledQueryRequest describeScheduledQueryRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScheduledQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeScheduledQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeScheduledQueryRequest));
    }

    private static /* synthetic */ void lambda$describeEndpoints$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpoints$30(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEndpointsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeAccountSettings$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccountSettings$26(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeAccountSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$describeAccountSettings$24(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DescribeAccountSettingsRequest describeAccountSettingsRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAccountSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeAccountSettingsRequest));
    }

    private static /* synthetic */ void lambda$deleteScheduledQuery$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteScheduledQuery$19(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteScheduledQueryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$deleteScheduledQuery$17(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DeleteScheduledQueryRequest deleteScheduledQueryRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteScheduledQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteScheduledQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)deleteScheduledQueryRequest));
    }

    private static /* synthetic */ void lambda$createScheduledQuery$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createScheduledQuery$12(List metricPublishers, MetricCollector apiCallMetricCollector, CreateScheduledQueryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$createScheduledQuery$10(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, CreateScheduledQueryRequest createScheduledQueryRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateScheduledQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateScheduledQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)createScheduledQueryRequest));
    }

    private static /* synthetic */ void lambda$cancelQuery$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelQuery$5(List metricPublishers, MetricCollector apiCallMetricCollector, CancelQueryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$cancelQuery$3(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, CancelQueryRequest cancelQueryRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CancelQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)cancelQueryRequest));
    }
}

