/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreamquery.model.TimestreamQueryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrepareQueryRequest
extends TimestreamQueryRequest
implements ToCopyableBuilder<Builder, PrepareQueryRequest> {
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryString").getter(PrepareQueryRequest.getter(PrepareQueryRequest::queryString)).setter(PrepareQueryRequest.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()}).build();
    private static final SdkField<Boolean> VALIDATE_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ValidateOnly").getter(PrepareQueryRequest.getter(PrepareQueryRequest::validateOnly)).setter(PrepareQueryRequest.setter(Builder::validateOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidateOnly").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STRING_FIELD, VALIDATE_ONLY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PrepareQueryRequest.memberNameToFieldInitializer();
    private final String queryString;
    private final Boolean validateOnly;

    private PrepareQueryRequest(BuilderImpl builder) {
        super(builder);
        this.queryString = builder.queryString;
        this.validateOnly = builder.validateOnly;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final Boolean validateOnly() {
        return this.validateOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validateOnly());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrepareQueryRequest)) {
            return false;
        }
        PrepareQueryRequest other = (PrepareQueryRequest)((Object)obj);
        return Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.validateOnly(), other.validateOnly());
    }

    public final String toString() {
        return ToString.builder((String)"PrepareQueryRequest").add("QueryString", (Object)(this.queryString() == null ? null : "*** Sensitive Data Redacted ***")).add("ValidateOnly", (Object)this.validateOnly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "ValidateOnly": {
                return Optional.ofNullable(clazz.cast(this.validateOnly()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("QueryString", QUERY_STRING_FIELD);
        map.put("ValidateOnly", VALIDATE_ONLY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrepareQueryRequest, T> g) {
        return obj -> g.apply((PrepareQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamQueryRequest.BuilderImpl
    implements Builder {
        private String queryString;
        private Boolean validateOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(PrepareQueryRequest model) {
            super(model);
            this.queryString(model.queryString);
            this.validateOnly(model.validateOnly);
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Boolean getValidateOnly() {
            return this.validateOnly;
        }

        public final void setValidateOnly(Boolean validateOnly) {
            this.validateOnly = validateOnly;
        }

        @Override
        public final Builder validateOnly(Boolean validateOnly) {
            this.validateOnly = validateOnly;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PrepareQueryRequest build() {
            return new PrepareQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TimestreamQueryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PrepareQueryRequest> {
        public Builder queryString(String var1);

        public Builder validateOnly(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

