/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines configuration details about the data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceConfiguration.Builder, DataSourceConfiguration> {
    private static final SdkField<DataSourceS3Configuration> DATA_SOURCE_S3_CONFIGURATION_FIELD = SdkField
            .<DataSourceS3Configuration> builder(MarshallingType.SDK_POJO).memberName("DataSourceS3Configuration")
            .getter(getter(DataSourceConfiguration::dataSourceS3Configuration))
            .setter(setter(Builder::dataSourceS3Configuration)).constructor(DataSourceS3Configuration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceS3Configuration").build())
            .build();

    private static final SdkField<CsvConfiguration> CSV_CONFIGURATION_FIELD = SdkField
            .<CsvConfiguration> builder(MarshallingType.SDK_POJO).memberName("CsvConfiguration")
            .getter(getter(DataSourceConfiguration::csvConfiguration)).setter(setter(Builder::csvConfiguration))
            .constructor(CsvConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvConfiguration").build()).build();

    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataFormat").getter(getter(DataSourceConfiguration::dataFormatAsString))
            .setter(setter(Builder::dataFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_SOURCE_S3_CONFIGURATION_FIELD, CSV_CONFIGURATION_FIELD, DATA_FORMAT_FIELD));

    private static final long serialVersionUID = 1L;

    private final DataSourceS3Configuration dataSourceS3Configuration;

    private final CsvConfiguration csvConfiguration;

    private final String dataFormat;

    private DataSourceConfiguration(BuilderImpl builder) {
        this.dataSourceS3Configuration = builder.dataSourceS3Configuration;
        this.csvConfiguration = builder.csvConfiguration;
        this.dataFormat = builder.dataFormat;
    }

    /**
     * <p>
     * Configuration of an S3 location for a file which contains data to load.
     * </p>
     * 
     * @return Configuration of an S3 location for a file which contains data to load.
     */
    public final DataSourceS3Configuration dataSourceS3Configuration() {
        return dataSourceS3Configuration;
    }

    /**
     * Returns the value of the CsvConfiguration property for this object.
     * 
     * @return The value of the CsvConfiguration property for this object.
     */
    public final CsvConfiguration csvConfiguration() {
        return csvConfiguration;
    }

    /**
     * <p>
     * This is currently CSV.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link BatchLoadDataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataFormatAsString}.
     * </p>
     * 
     * @return This is currently CSV.
     * @see BatchLoadDataFormat
     */
    public final BatchLoadDataFormat dataFormat() {
        return BatchLoadDataFormat.fromValue(dataFormat);
    }

    /**
     * <p>
     * This is currently CSV.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link BatchLoadDataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataFormatAsString}.
     * </p>
     * 
     * @return This is currently CSV.
     * @see BatchLoadDataFormat
     */
    public final String dataFormatAsString() {
        return dataFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceS3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(csvConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dataFormatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfiguration)) {
            return false;
        }
        DataSourceConfiguration other = (DataSourceConfiguration) obj;
        return Objects.equals(dataSourceS3Configuration(), other.dataSourceS3Configuration())
                && Objects.equals(csvConfiguration(), other.csvConfiguration())
                && Objects.equals(dataFormatAsString(), other.dataFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceConfiguration").add("DataSourceS3Configuration", dataSourceS3Configuration())
                .add("CsvConfiguration", csvConfiguration()).add("DataFormat", dataFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceS3Configuration":
            return Optional.ofNullable(clazz.cast(dataSourceS3Configuration()));
        case "CsvConfiguration":
            return Optional.ofNullable(clazz.cast(csvConfiguration()));
        case "DataFormat":
            return Optional.ofNullable(clazz.cast(dataFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfiguration, T> g) {
        return obj -> g.apply((DataSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceConfiguration> {
        /**
         * <p>
         * Configuration of an S3 location for a file which contains data to load.
         * </p>
         * 
         * @param dataSourceS3Configuration
         *        Configuration of an S3 location for a file which contains data to load.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceS3Configuration(DataSourceS3Configuration dataSourceS3Configuration);

        /**
         * <p>
         * Configuration of an S3 location for a file which contains data to load.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceS3Configuration.Builder}
         * avoiding the need to create one manually via {@link DataSourceS3Configuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceS3Configuration.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSourceS3Configuration(DataSourceS3Configuration)}.
         * 
         * @param dataSourceS3Configuration
         *        a consumer that will call methods on {@link DataSourceS3Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSourceS3Configuration(DataSourceS3Configuration)
         */
        default Builder dataSourceS3Configuration(Consumer<DataSourceS3Configuration.Builder> dataSourceS3Configuration) {
            return dataSourceS3Configuration(DataSourceS3Configuration.builder().applyMutation(dataSourceS3Configuration).build());
        }

        /**
         * Sets the value of the CsvConfiguration property for this object.
         *
         * @param csvConfiguration
         *        The new value for the CsvConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvConfiguration(CsvConfiguration csvConfiguration);

        /**
         * Sets the value of the CsvConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CsvConfiguration.Builder} avoiding the
         * need to create one manually via {@link CsvConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CsvConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #csvConfiguration(CsvConfiguration)}.
         * 
         * @param csvConfiguration
         *        a consumer that will call methods on {@link CsvConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #csvConfiguration(CsvConfiguration)
         */
        default Builder csvConfiguration(Consumer<CsvConfiguration.Builder> csvConfiguration) {
            return csvConfiguration(CsvConfiguration.builder().applyMutation(csvConfiguration).build());
        }

        /**
         * <p>
         * This is currently CSV.
         * </p>
         * 
         * @param dataFormat
         *        This is currently CSV.
         * @see BatchLoadDataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchLoadDataFormat
         */
        Builder dataFormat(String dataFormat);

        /**
         * <p>
         * This is currently CSV.
         * </p>
         * 
         * @param dataFormat
         *        This is currently CSV.
         * @see BatchLoadDataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchLoadDataFormat
         */
        Builder dataFormat(BatchLoadDataFormat dataFormat);
    }

    static final class BuilderImpl implements Builder {
        private DataSourceS3Configuration dataSourceS3Configuration;

        private CsvConfiguration csvConfiguration;

        private String dataFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfiguration model) {
            dataSourceS3Configuration(model.dataSourceS3Configuration);
            csvConfiguration(model.csvConfiguration);
            dataFormat(model.dataFormat);
        }

        public final DataSourceS3Configuration.Builder getDataSourceS3Configuration() {
            return dataSourceS3Configuration != null ? dataSourceS3Configuration.toBuilder() : null;
        }

        public final void setDataSourceS3Configuration(DataSourceS3Configuration.BuilderImpl dataSourceS3Configuration) {
            this.dataSourceS3Configuration = dataSourceS3Configuration != null ? dataSourceS3Configuration.build() : null;
        }

        @Override
        public final Builder dataSourceS3Configuration(DataSourceS3Configuration dataSourceS3Configuration) {
            this.dataSourceS3Configuration = dataSourceS3Configuration;
            return this;
        }

        public final CsvConfiguration.Builder getCsvConfiguration() {
            return csvConfiguration != null ? csvConfiguration.toBuilder() : null;
        }

        public final void setCsvConfiguration(CsvConfiguration.BuilderImpl csvConfiguration) {
            this.csvConfiguration = csvConfiguration != null ? csvConfiguration.build() : null;
        }

        @Override
        public final Builder csvConfiguration(CsvConfiguration csvConfiguration) {
            this.csvConfiguration = csvConfiguration;
            return this;
        }

        public final String getDataFormat() {
            return dataFormat;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(BatchLoadDataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        @Override
        public DataSourceConfiguration build() {
            return new DataSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
