/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteClient;
import software.amazon.awssdk.services.timestreamwrite.internal.UserAgentUtils;
import software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksResponse;

public class ListBatchLoadTasksIterable
implements SdkIterable<ListBatchLoadTasksResponse> {
    private final TimestreamWriteClient client;
    private final ListBatchLoadTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBatchLoadTasksIterable(TimestreamWriteClient client, ListBatchLoadTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBatchLoadTasksResponseFetcher();
    }

    public Iterator<ListBatchLoadTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListBatchLoadTasksResponseFetcher
    implements SyncPageFetcher<ListBatchLoadTasksResponse> {
        private ListBatchLoadTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListBatchLoadTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBatchLoadTasksResponse nextPage(ListBatchLoadTasksResponse previousPage) {
            if (previousPage == null) {
                return ListBatchLoadTasksIterable.this.client.listBatchLoadTasks(ListBatchLoadTasksIterable.this.firstRequest);
            }
            return ListBatchLoadTasksIterable.this.client.listBatchLoadTasks((ListBatchLoadTasksRequest)((Object)ListBatchLoadTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

