/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An attribute used in partitioning data in a table. A dimension key partitions data using the values of the dimension
 * specified by the dimension-name as partition key, while a measure key partitions data using measure names (values of
 * the 'measure_name' column).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PartitionKey implements SdkPojo, Serializable, ToCopyableBuilder<PartitionKey.Builder, PartitionKey> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(PartitionKey::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PartitionKey::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ENFORCEMENT_IN_RECORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnforcementInRecord").getter(getter(PartitionKey::enforcementInRecordAsString))
            .setter(setter(Builder::enforcementInRecord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforcementInRecord").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NAME_FIELD,
            ENFORCEMENT_IN_RECORD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String name;

    private final String enforcementInRecord;

    private PartitionKey(BuilderImpl builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.enforcementInRecord = builder.enforcementInRecord;
    }

    /**
     * <p>
     * The type of the partition key. Options are DIMENSION (dimension key) and MEASURE (measure key).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PartitionKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the partition key. Options are DIMENSION (dimension key) and MEASURE (measure key).
     * @see PartitionKeyType
     */
    public final PartitionKeyType type() {
        return PartitionKeyType.fromValue(type);
    }

    /**
     * <p>
     * The type of the partition key. Options are DIMENSION (dimension key) and MEASURE (measure key).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PartitionKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the partition key. Options are DIMENSION (dimension key) and MEASURE (measure key).
     * @see PartitionKeyType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the attribute used for a dimension key.
     * </p>
     * 
     * @return The name of the attribute used for a dimension key.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The level of enforcement for the specification of a dimension key in ingested records. Options are REQUIRED
     * (dimension key must be specified) and OPTIONAL (dimension key does not have to be specified).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enforcementInRecord} will return {@link PartitionKeyEnforcementLevel#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #enforcementInRecordAsString}.
     * </p>
     * 
     * @return The level of enforcement for the specification of a dimension key in ingested records. Options are
     *         REQUIRED (dimension key must be specified) and OPTIONAL (dimension key does not have to be specified).
     * @see PartitionKeyEnforcementLevel
     */
    public final PartitionKeyEnforcementLevel enforcementInRecord() {
        return PartitionKeyEnforcementLevel.fromValue(enforcementInRecord);
    }

    /**
     * <p>
     * The level of enforcement for the specification of a dimension key in ingested records. Options are REQUIRED
     * (dimension key must be specified) and OPTIONAL (dimension key does not have to be specified).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enforcementInRecord} will return {@link PartitionKeyEnforcementLevel#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #enforcementInRecordAsString}.
     * </p>
     * 
     * @return The level of enforcement for the specification of a dimension key in ingested records. Options are
     *         REQUIRED (dimension key must be specified) and OPTIONAL (dimension key does not have to be specified).
     * @see PartitionKeyEnforcementLevel
     */
    public final String enforcementInRecordAsString() {
        return enforcementInRecord;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(enforcementInRecordAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartitionKey)) {
            return false;
        }
        PartitionKey other = (PartitionKey) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(enforcementInRecordAsString(), other.enforcementInRecordAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PartitionKey").add("Type", typeAsString()).add("Name", name())
                .add("EnforcementInRecord", enforcementInRecordAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "EnforcementInRecord":
            return Optional.ofNullable(clazz.cast(enforcementInRecordAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PartitionKey, T> g) {
        return obj -> g.apply((PartitionKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PartitionKey> {
        /**
         * <p>
         * The type of the partition key. Options are DIMENSION (dimension key) and MEASURE (measure key).
         * </p>
         * 
         * @param type
         *        The type of the partition key. Options are DIMENSION (dimension key) and MEASURE (measure key).
         * @see PartitionKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartitionKeyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the partition key. Options are DIMENSION (dimension key) and MEASURE (measure key).
         * </p>
         * 
         * @param type
         *        The type of the partition key. Options are DIMENSION (dimension key) and MEASURE (measure key).
         * @see PartitionKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartitionKeyType
         */
        Builder type(PartitionKeyType type);

        /**
         * <p>
         * The name of the attribute used for a dimension key.
         * </p>
         * 
         * @param name
         *        The name of the attribute used for a dimension key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The level of enforcement for the specification of a dimension key in ingested records. Options are REQUIRED
         * (dimension key must be specified) and OPTIONAL (dimension key does not have to be specified).
         * </p>
         * 
         * @param enforcementInRecord
         *        The level of enforcement for the specification of a dimension key in ingested records. Options are
         *        REQUIRED (dimension key must be specified) and OPTIONAL (dimension key does not have to be specified).
         * @see PartitionKeyEnforcementLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartitionKeyEnforcementLevel
         */
        Builder enforcementInRecord(String enforcementInRecord);

        /**
         * <p>
         * The level of enforcement for the specification of a dimension key in ingested records. Options are REQUIRED
         * (dimension key must be specified) and OPTIONAL (dimension key does not have to be specified).
         * </p>
         * 
         * @param enforcementInRecord
         *        The level of enforcement for the specification of a dimension key in ingested records. Options are
         *        REQUIRED (dimension key must be specified) and OPTIONAL (dimension key does not have to be specified).
         * @see PartitionKeyEnforcementLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartitionKeyEnforcementLevel
         */
        Builder enforcementInRecord(PartitionKeyEnforcementLevel enforcementInRecord);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String name;

        private String enforcementInRecord;

        private BuilderImpl() {
        }

        private BuilderImpl(PartitionKey model) {
            type(model.type);
            name(model.name);
            enforcementInRecord(model.enforcementInRecord);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PartitionKeyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEnforcementInRecord() {
            return enforcementInRecord;
        }

        public final void setEnforcementInRecord(String enforcementInRecord) {
            this.enforcementInRecord = enforcementInRecord;
        }

        @Override
        public final Builder enforcementInRecord(String enforcementInRecord) {
            this.enforcementInRecord = enforcementInRecord;
            return this;
        }

        @Override
        public final Builder enforcementInRecord(PartitionKeyEnforcementLevel enforcementInRecord) {
            this.enforcementInRecord(enforcementInRecord == null ? null : enforcementInRecord.toString());
            return this;
        }

        @Override
        public PartitionKey build() {
            return new PartitionKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
