/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchLoadTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchLoadTask> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskId").getter(BatchLoadTask.getter(BatchLoadTask::taskId)).setter(BatchLoadTask.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()}).build();
    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskStatus").getter(BatchLoadTask.getter(BatchLoadTask::taskStatusAsString)).setter(BatchLoadTask.setter(Builder::taskStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskStatus").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(BatchLoadTask.getter(BatchLoadTask::databaseName)).setter(BatchLoadTask.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(BatchLoadTask.getter(BatchLoadTask::tableName)).setter(BatchLoadTask.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(BatchLoadTask.getter(BatchLoadTask::creationTime)).setter(BatchLoadTask.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(BatchLoadTask.getter(BatchLoadTask::lastUpdatedTime)).setter(BatchLoadTask.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<Instant> RESUMABLE_UNTIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ResumableUntil").getter(BatchLoadTask.getter(BatchLoadTask::resumableUntil)).setter(BatchLoadTask.setter(Builder::resumableUntil)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResumableUntil").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, TASK_STATUS_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, RESUMABLE_UNTIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TaskId", TASK_ID_FIELD);
            this.put("TaskStatus", TASK_STATUS_FIELD);
            this.put("DatabaseName", DATABASE_NAME_FIELD);
            this.put("TableName", TABLE_NAME_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
            this.put("ResumableUntil", RESUMABLE_UNTIL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String taskId;
    private final String taskStatus;
    private final String databaseName;
    private final String tableName;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;
    private final Instant resumableUntil;

    private BatchLoadTask(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.taskStatus = builder.taskStatus;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.resumableUntil = builder.resumableUntil;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final BatchLoadStatus taskStatus() {
        return BatchLoadStatus.fromValue(this.taskStatus);
    }

    public final String taskStatusAsString() {
        return this.taskStatus;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final Instant resumableUntil() {
        return this.resumableUntil;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.resumableUntil());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchLoadTask)) {
            return false;
        }
        BatchLoadTask other = (BatchLoadTask)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.taskStatusAsString(), other.taskStatusAsString()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.resumableUntil(), other.resumableUntil());
    }

    public final String toString() {
        return ToString.builder((String)"BatchLoadTask").add("TaskId", (Object)this.taskId()).add("TaskStatus", (Object)this.taskStatusAsString()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("ResumableUntil", (Object)this.resumableUntil()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "TaskStatus": {
                return Optional.ofNullable(clazz.cast(this.taskStatusAsString()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "ResumableUntil": {
                return Optional.ofNullable(clazz.cast(this.resumableUntil()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchLoadTask, T> g) {
        return obj -> g.apply((BatchLoadTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String taskStatus;
        private String databaseName;
        private String tableName;
        private Instant creationTime;
        private Instant lastUpdatedTime;
        private Instant resumableUntil;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchLoadTask model) {
            this.taskId(model.taskId);
            this.taskStatus(model.taskStatus);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.resumableUntil(model.resumableUntil);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getTaskStatus() {
            return this.taskStatus;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(BatchLoadStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Instant getResumableUntil() {
            return this.resumableUntil;
        }

        public final void setResumableUntil(Instant resumableUntil) {
            this.resumableUntil = resumableUntil;
        }

        @Override
        public final Builder resumableUntil(Instant resumableUntil) {
            this.resumableUntil = resumableUntil;
            return this;
        }

        public BatchLoadTask build() {
            return new BatchLoadTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchLoadTask> {
        public Builder taskId(String var1);

        public Builder taskStatus(String var1);

        public Builder taskStatus(BatchLoadStatus var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder resumableUntil(Instant var1);
    }
}

