/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.timestreamwrite.model.PartitionKey;
import software.amazon.awssdk.services.timestreamwrite.model.PartitionKeyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Schema
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Schema> {
    private static final SdkField<List<PartitionKey>> COMPOSITE_PARTITION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CompositePartitionKey").getter(Schema.getter(Schema::compositePartitionKey)).setter(Schema.setter(Builder::compositePartitionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositePartitionKey").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PartitionKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPOSITE_PARTITION_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Schema.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<PartitionKey> compositePartitionKey;

    private Schema(BuilderImpl builder) {
        this.compositePartitionKey = builder.compositePartitionKey;
    }

    public final boolean hasCompositePartitionKey() {
        return this.compositePartitionKey != null && !(this.compositePartitionKey instanceof SdkAutoConstructList);
    }

    public final List<PartitionKey> compositePartitionKey() {
        return this.compositePartitionKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompositePartitionKey() ? this.compositePartitionKey() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)obj;
        return this.hasCompositePartitionKey() == other.hasCompositePartitionKey() && Objects.equals(this.compositePartitionKey(), other.compositePartitionKey());
    }

    public final String toString() {
        return ToString.builder((String)"Schema").add("CompositePartitionKey", this.hasCompositePartitionKey() ? this.compositePartitionKey() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompositePartitionKey": {
                return Optional.ofNullable(clazz.cast(this.compositePartitionKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<PartitionKey>>> map = new HashMap<String, SdkField<List<PartitionKey>>>();
        map.put("CompositePartitionKey", COMPOSITE_PARTITION_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Schema, T> g) {
        return obj -> g.apply((Schema)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PartitionKey> compositePartitionKey = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Schema model) {
            this.compositePartitionKey(model.compositePartitionKey);
        }

        public final List<PartitionKey.Builder> getCompositePartitionKey() {
            List<PartitionKey.Builder> result = PartitionKeyListCopier.copyToBuilder(this.compositePartitionKey);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCompositePartitionKey(Collection<PartitionKey.BuilderImpl> compositePartitionKey) {
            this.compositePartitionKey = PartitionKeyListCopier.copyFromBuilder(compositePartitionKey);
        }

        @Override
        public final Builder compositePartitionKey(Collection<PartitionKey> compositePartitionKey) {
            this.compositePartitionKey = PartitionKeyListCopier.copy(compositePartitionKey);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compositePartitionKey(PartitionKey ... compositePartitionKey) {
            this.compositePartitionKey(Arrays.asList(compositePartitionKey));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compositePartitionKey(Consumer<PartitionKey.Builder> ... compositePartitionKey) {
            this.compositePartitionKey(Stream.of(compositePartitionKey).map(c -> (PartitionKey)((PartitionKey.Builder)PartitionKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Schema build() {
            return new Schema(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Schema> {
        public Builder compositePartitionKey(Collection<PartitionKey> var1);

        public Builder compositePartitionKey(PartitionKey ... var1);

        public Builder compositePartitionKey(Consumer<PartitionKey.Builder> ... var1);
    }
}

