/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.tnb.model.PackageContentType;
import software.amazon.awssdk.services.tnb.model.TnbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutSolFunctionPackageContentRequest
extends TnbRequest
implements ToCopyableBuilder<Builder, PutSolFunctionPackageContentRequest> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(PutSolFunctionPackageContentRequest.getter(PutSolFunctionPackageContentRequest::contentTypeAsString)).setter(PutSolFunctionPackageContentRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<SdkBytes> FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("file").getter(PutSolFunctionPackageContentRequest.getter(PutSolFunctionPackageContentRequest::file)).setter(PutSolFunctionPackageContentRequest.setter(Builder::file)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> VNF_PKG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vnfPkgId").getter(PutSolFunctionPackageContentRequest.getter(PutSolFunctionPackageContentRequest::vnfPkgId)).setter(PutSolFunctionPackageContentRequest.setter(Builder::vnfPkgId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("vnfPkgId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD, FILE_FIELD, VNF_PKG_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutSolFunctionPackageContentRequest.memberNameToFieldInitializer();
    private final String contentType;
    private final SdkBytes file;
    private final String vnfPkgId;

    private PutSolFunctionPackageContentRequest(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.file = builder.file;
        this.vnfPkgId = builder.vnfPkgId;
    }

    public final PackageContentType contentType() {
        return PackageContentType.fromValue(this.contentType);
    }

    public final String contentTypeAsString() {
        return this.contentType;
    }

    public final SdkBytes file() {
        return this.file;
    }

    public final String vnfPkgId() {
        return this.vnfPkgId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.file());
        hashCode = 31 * hashCode + Objects.hashCode(this.vnfPkgId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSolFunctionPackageContentRequest)) {
            return false;
        }
        PutSolFunctionPackageContentRequest other = (PutSolFunctionPackageContentRequest)((Object)obj);
        return Objects.equals(this.contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(this.file(), other.file()) && Objects.equals(this.vnfPkgId(), other.vnfPkgId());
    }

    public final String toString() {
        return ToString.builder((String)"PutSolFunctionPackageContentRequest").add("ContentType", (Object)this.contentTypeAsString()).add("File", (Object)(this.file() == null ? null : "*** Sensitive Data Redacted ***")).add("VnfPkgId", (Object)this.vnfPkgId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentTypeAsString()));
            }
            case "file": {
                return Optional.ofNullable(clazz.cast(this.file()));
            }
            case "vnfPkgId": {
                return Optional.ofNullable(clazz.cast(this.vnfPkgId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        map.put("file", FILE_FIELD);
        map.put("vnfPkgId", VNF_PKG_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutSolFunctionPackageContentRequest, T> g) {
        return obj -> g.apply((PutSolFunctionPackageContentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TnbRequest.BuilderImpl
    implements Builder {
        private String contentType;
        private SdkBytes file;
        private String vnfPkgId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSolFunctionPackageContentRequest model) {
            super(model);
            this.contentType(model.contentType);
            this.file(model.file);
            this.vnfPkgId(model.vnfPkgId);
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(PackageContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final ByteBuffer getFile() {
            return this.file == null ? null : this.file.asByteBuffer();
        }

        public final void setFile(ByteBuffer file) {
            this.file(file == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)file));
        }

        @Override
        public final Builder file(SdkBytes file) {
            this.file = file;
            return this;
        }

        public final String getVnfPkgId() {
            return this.vnfPkgId;
        }

        public final void setVnfPkgId(String vnfPkgId) {
            this.vnfPkgId = vnfPkgId;
        }

        @Override
        public final Builder vnfPkgId(String vnfPkgId) {
            this.vnfPkgId = vnfPkgId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSolFunctionPackageContentRequest build() {
            return new PutSolFunctionPackageContentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TnbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutSolFunctionPackageContentRequest> {
        public Builder contentType(String var1);

        public Builder contentType(PackageContentType var1);

        public Builder file(SdkBytes var1);

        public Builder vnfPkgId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

