/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.TranscribeRequest;
import software.amazon.awssdk.services.transcribe.model.WordsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVocabularyFilterRequest
extends TranscribeRequest
implements ToCopyableBuilder<Builder, UpdateVocabularyFilterRequest> {
    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterName").getter(UpdateVocabularyFilterRequest.getter(UpdateVocabularyFilterRequest::vocabularyFilterName)).setter(UpdateVocabularyFilterRequest.setter(Builder::vocabularyFilterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build()}).build();
    private static final SdkField<List<String>> WORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Words").getter(UpdateVocabularyFilterRequest.getter(UpdateVocabularyFilterRequest::words)).setter(UpdateVocabularyFilterRequest.setter(Builder::words)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Words").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_FILE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterFileUri").getter(UpdateVocabularyFilterRequest.getter(UpdateVocabularyFilterRequest::vocabularyFilterFileUri)).setter(UpdateVocabularyFilterRequest.setter(Builder::vocabularyFilterFileUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterFileUri").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(UpdateVocabularyFilterRequest.getter(UpdateVocabularyFilterRequest::dataAccessRoleArn)).setter(UpdateVocabularyFilterRequest.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_FILTER_NAME_FIELD, WORDS_FIELD, VOCABULARY_FILTER_FILE_URI_FIELD, DATA_ACCESS_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateVocabularyFilterRequest.memberNameToFieldInitializer();
    private final String vocabularyFilterName;
    private final List<String> words;
    private final String vocabularyFilterFileUri;
    private final String dataAccessRoleArn;

    private UpdateVocabularyFilterRequest(BuilderImpl builder) {
        super(builder);
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.words = builder.words;
        this.vocabularyFilterFileUri = builder.vocabularyFilterFileUri;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
    }

    public final String vocabularyFilterName() {
        return this.vocabularyFilterName;
    }

    public final boolean hasWords() {
        return this.words != null && !(this.words instanceof SdkAutoConstructList);
    }

    public final List<String> words() {
        return this.words;
    }

    public final String vocabularyFilterFileUri() {
        return this.vocabularyFilterFileUri;
    }

    public final String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWords() ? this.words() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterFileUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVocabularyFilterRequest)) {
            return false;
        }
        UpdateVocabularyFilterRequest other = (UpdateVocabularyFilterRequest)((Object)obj);
        return Objects.equals(this.vocabularyFilterName(), other.vocabularyFilterName()) && this.hasWords() == other.hasWords() && Objects.equals(this.words(), other.words()) && Objects.equals(this.vocabularyFilterFileUri(), other.vocabularyFilterFileUri()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateVocabularyFilterRequest").add("VocabularyFilterName", (Object)this.vocabularyFilterName()).add("Words", this.hasWords() ? this.words() : null).add("VocabularyFilterFileUri", (Object)this.vocabularyFilterFileUri()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VocabularyFilterName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterName()));
            }
            case "Words": {
                return Optional.ofNullable(clazz.cast(this.words()));
            }
            case "VocabularyFilterFileUri": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterFileUri()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VocabularyFilterName", VOCABULARY_FILTER_NAME_FIELD);
        map.put("Words", WORDS_FIELD);
        map.put("VocabularyFilterFileUri", VOCABULARY_FILTER_FILE_URI_FIELD);
        map.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVocabularyFilterRequest, T> g) {
        return obj -> g.apply((UpdateVocabularyFilterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeRequest.BuilderImpl
    implements Builder {
        private String vocabularyFilterName;
        private List<String> words = DefaultSdkAutoConstructList.getInstance();
        private String vocabularyFilterFileUri;
        private String dataAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVocabularyFilterRequest model) {
            super(model);
            this.vocabularyFilterName(model.vocabularyFilterName);
            this.words(model.words);
            this.vocabularyFilterFileUri(model.vocabularyFilterFileUri);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
        }

        public final String getVocabularyFilterName() {
            return this.vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final Collection<String> getWords() {
            if (this.words instanceof SdkAutoConstructList) {
                return null;
            }
            return this.words;
        }

        public final void setWords(Collection<String> words) {
            this.words = WordsCopier.copy(words);
        }

        @Override
        public final Builder words(Collection<String> words) {
            this.words = WordsCopier.copy(words);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder words(String ... words) {
            this.words(Arrays.asList(words));
            return this;
        }

        public final String getVocabularyFilterFileUri() {
            return this.vocabularyFilterFileUri;
        }

        public final void setVocabularyFilterFileUri(String vocabularyFilterFileUri) {
            this.vocabularyFilterFileUri = vocabularyFilterFileUri;
        }

        @Override
        public final Builder vocabularyFilterFileUri(String vocabularyFilterFileUri) {
            this.vocabularyFilterFileUri = vocabularyFilterFileUri;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVocabularyFilterRequest build() {
            return new UpdateVocabularyFilterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TranscribeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVocabularyFilterRequest> {
        public Builder vocabularyFilterName(String var1);

        public Builder words(Collection<String> var1);

        public Builder words(String ... var1);

        public Builder vocabularyFilterFileUri(String var1);

        public Builder dataAccessRoleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

