/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.SubtitleFileUrisCopier;
import software.amazon.awssdk.services.transcribe.model.SubtitleFormat;
import software.amazon.awssdk.services.transcribe.model.SubtitleFormatsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubtitlesOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubtitlesOutput> {
    private static final SdkField<List<String>> FORMATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Formats").getter(SubtitlesOutput.getter(SubtitlesOutput::formatsAsStrings)).setter(SubtitlesOutput.setter(Builder::formatsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Formats").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBTITLE_FILE_URIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubtitleFileUris").getter(SubtitlesOutput.getter(SubtitlesOutput::subtitleFileUris)).setter(SubtitlesOutput.setter(Builder::subtitleFileUris)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubtitleFileUris").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> OUTPUT_START_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OutputStartIndex").getter(SubtitlesOutput.getter(SubtitlesOutput::outputStartIndex)).setter(SubtitlesOutput.setter(Builder::outputStartIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputStartIndex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMATS_FIELD, SUBTITLE_FILE_URIS_FIELD, OUTPUT_START_INDEX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubtitlesOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> formats;
    private final List<String> subtitleFileUris;
    private final Integer outputStartIndex;

    private SubtitlesOutput(BuilderImpl builder) {
        this.formats = builder.formats;
        this.subtitleFileUris = builder.subtitleFileUris;
        this.outputStartIndex = builder.outputStartIndex;
    }

    public final List<SubtitleFormat> formats() {
        return SubtitleFormatsCopier.copyStringToEnum(this.formats);
    }

    public final boolean hasFormats() {
        return this.formats != null && !(this.formats instanceof SdkAutoConstructList);
    }

    public final List<String> formatsAsStrings() {
        return this.formats;
    }

    public final boolean hasSubtitleFileUris() {
        return this.subtitleFileUris != null && !(this.subtitleFileUris instanceof SdkAutoConstructList);
    }

    public final List<String> subtitleFileUris() {
        return this.subtitleFileUris;
    }

    public final Integer outputStartIndex() {
        return this.outputStartIndex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFormats() ? this.formatsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubtitleFileUris() ? this.subtitleFileUris() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputStartIndex());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubtitlesOutput)) {
            return false;
        }
        SubtitlesOutput other = (SubtitlesOutput)obj;
        return this.hasFormats() == other.hasFormats() && Objects.equals(this.formatsAsStrings(), other.formatsAsStrings()) && this.hasSubtitleFileUris() == other.hasSubtitleFileUris() && Objects.equals(this.subtitleFileUris(), other.subtitleFileUris()) && Objects.equals(this.outputStartIndex(), other.outputStartIndex());
    }

    public final String toString() {
        return ToString.builder((String)"SubtitlesOutput").add("Formats", this.hasFormats() ? this.formatsAsStrings() : null).add("SubtitleFileUris", this.hasSubtitleFileUris() ? this.subtitleFileUris() : null).add("OutputStartIndex", (Object)this.outputStartIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Formats": {
                return Optional.ofNullable(clazz.cast(this.formatsAsStrings()));
            }
            case "SubtitleFileUris": {
                return Optional.ofNullable(clazz.cast(this.subtitleFileUris()));
            }
            case "OutputStartIndex": {
                return Optional.ofNullable(clazz.cast(this.outputStartIndex()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Formats", FORMATS_FIELD);
        map.put("SubtitleFileUris", SUBTITLE_FILE_URIS_FIELD);
        map.put("OutputStartIndex", OUTPUT_START_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubtitlesOutput, T> g) {
        return obj -> g.apply((SubtitlesOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> formats = DefaultSdkAutoConstructList.getInstance();
        private List<String> subtitleFileUris = DefaultSdkAutoConstructList.getInstance();
        private Integer outputStartIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(SubtitlesOutput model) {
            this.formatsWithStrings(model.formats);
            this.subtitleFileUris(model.subtitleFileUris);
            this.outputStartIndex(model.outputStartIndex);
        }

        public final Collection<String> getFormats() {
            if (this.formats instanceof SdkAutoConstructList) {
                return null;
            }
            return this.formats;
        }

        public final void setFormats(Collection<String> formats) {
            this.formats = SubtitleFormatsCopier.copy(formats);
        }

        @Override
        public final Builder formatsWithStrings(Collection<String> formats) {
            this.formats = SubtitleFormatsCopier.copy(formats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formatsWithStrings(String ... formats) {
            this.formatsWithStrings(Arrays.asList(formats));
            return this;
        }

        @Override
        public final Builder formats(Collection<SubtitleFormat> formats) {
            this.formats = SubtitleFormatsCopier.copyEnumToString(formats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formats(SubtitleFormat ... formats) {
            this.formats(Arrays.asList(formats));
            return this;
        }

        public final Collection<String> getSubtitleFileUris() {
            if (this.subtitleFileUris instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subtitleFileUris;
        }

        public final void setSubtitleFileUris(Collection<String> subtitleFileUris) {
            this.subtitleFileUris = SubtitleFileUrisCopier.copy(subtitleFileUris);
        }

        @Override
        public final Builder subtitleFileUris(Collection<String> subtitleFileUris) {
            this.subtitleFileUris = SubtitleFileUrisCopier.copy(subtitleFileUris);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subtitleFileUris(String ... subtitleFileUris) {
            this.subtitleFileUris(Arrays.asList(subtitleFileUris));
            return this;
        }

        public final Integer getOutputStartIndex() {
            return this.outputStartIndex;
        }

        public final void setOutputStartIndex(Integer outputStartIndex) {
            this.outputStartIndex = outputStartIndex;
        }

        @Override
        public final Builder outputStartIndex(Integer outputStartIndex) {
            this.outputStartIndex = outputStartIndex;
            return this;
        }

        public SubtitlesOutput build() {
            return new SubtitlesOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubtitlesOutput> {
        public Builder formatsWithStrings(Collection<String> var1);

        public Builder formatsWithStrings(String ... var1);

        public Builder formats(Collection<SubtitleFormat> var1);

        public Builder formats(SubtitleFormat ... var1);

        public Builder subtitleFileUris(Collection<String> var1);

        public Builder subtitleFileUris(String ... var1);

        public Builder outputStartIndex(Integer var1);
    }
}

