/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.transcribestreaming.model.KMSEncryptionContextMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MedicalScribeEncryptionSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MedicalScribeEncryptionSettings> {
    private static final SdkField<Map<String, String>> KMS_ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("KmsEncryptionContext").getter(MedicalScribeEncryptionSettings.getter(MedicalScribeEncryptionSettings::kmsEncryptionContext)).setter(MedicalScribeEncryptionSettings.setter(Builder::kmsEncryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsEncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(MedicalScribeEncryptionSettings.getter(MedicalScribeEncryptionSettings::kmsKeyId)).setter(MedicalScribeEncryptionSettings.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_ENCRYPTION_CONTEXT_FIELD, KMS_KEY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MedicalScribeEncryptionSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> kmsEncryptionContext;
    private final String kmsKeyId;

    private MedicalScribeEncryptionSettings(BuilderImpl builder) {
        this.kmsEncryptionContext = builder.kmsEncryptionContext;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final boolean hasKmsEncryptionContext() {
        return this.kmsEncryptionContext != null && !(this.kmsEncryptionContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> kmsEncryptionContext() {
        return this.kmsEncryptionContext;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKmsEncryptionContext() ? this.kmsEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeEncryptionSettings)) {
            return false;
        }
        MedicalScribeEncryptionSettings other = (MedicalScribeEncryptionSettings)obj;
        return this.hasKmsEncryptionContext() == other.hasKmsEncryptionContext() && Objects.equals(this.kmsEncryptionContext(), other.kmsEncryptionContext()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"MedicalScribeEncryptionSettings").add("KmsEncryptionContext", this.hasKmsEncryptionContext() ? this.kmsEncryptionContext() : null).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KmsEncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.kmsEncryptionContext()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KmsEncryptionContext", KMS_ENCRYPTION_CONTEXT_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeEncryptionSettings, T> g) {
        return obj -> g.apply((MedicalScribeEncryptionSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> kmsEncryptionContext = DefaultSdkAutoConstructMap.getInstance();
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalScribeEncryptionSettings model) {
            this.kmsEncryptionContext(model.kmsEncryptionContext);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final Map<String, String> getKmsEncryptionContext() {
            if (this.kmsEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.kmsEncryptionContext;
        }

        public final void setKmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = KMSEncryptionContextMapCopier.copy(kmsEncryptionContext);
        }

        @Override
        public final Builder kmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = KMSEncryptionContextMapCopier.copy(kmsEncryptionContext);
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public MedicalScribeEncryptionSettings build() {
            return new MedicalScribeEncryptionSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MedicalScribeEncryptionSettings> {
        public Builder kmsEncryptionContext(Map<String, String> var1);

        public Builder kmsKeyId(String var1);
    }
}

