/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectorEgressType {
    SERVICE_MANAGED("SERVICE_MANAGED"),
    VPC_LATTICE("VPC_LATTICE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectorEgressType> VALUE_MAP;
    private final String value;

    private ConnectorEgressType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectorEgressType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectorEgressType> knownValues() {
        EnumSet<ConnectorEgressType> knownValues = EnumSet.allOf(ConnectorEgressType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectorEgressType.class, ConnectorEgressType::toString);
    }
}

