/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.transfer.model.DescribedWebAppVpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribedWebAppEndpointDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribedWebAppEndpointDetails> {
    private static final SdkField<DescribedWebAppVpcConfig> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Vpc").getter(DescribedWebAppEndpointDetails.getter(DescribedWebAppEndpointDetails::vpc)).setter(DescribedWebAppEndpointDetails.setter(Builder::vpc)).constructor(DescribedWebAppVpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribedWebAppEndpointDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DescribedWebAppVpcConfig vpc;
    private final Type type;

    private DescribedWebAppEndpointDetails(BuilderImpl builder) {
        this.vpc = builder.vpc;
        this.type = builder.type;
    }

    public final DescribedWebAppVpcConfig vpc() {
        return this.vpc;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedWebAppEndpointDetails)) {
            return false;
        }
        DescribedWebAppEndpointDetails other = (DescribedWebAppEndpointDetails)obj;
        return Objects.equals(this.vpc(), other.vpc());
    }

    public final String toString() {
        return ToString.builder((String)"DescribedWebAppEndpointDetails").add("Vpc", (Object)this.vpc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
        }
        return Optional.empty();
    }

    public static DescribedWebAppEndpointDetails fromVpc(DescribedWebAppVpcConfig vpc) {
        return (DescribedWebAppEndpointDetails)DescribedWebAppEndpointDetails.builder().vpc(vpc).build();
    }

    public static DescribedWebAppEndpointDetails fromVpc(Consumer<DescribedWebAppVpcConfig.Builder> vpc) {
        DescribedWebAppVpcConfig.Builder builder = DescribedWebAppVpcConfig.builder();
        vpc.accept(builder);
        return DescribedWebAppEndpointDetails.fromVpc((DescribedWebAppVpcConfig)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<DescribedWebAppVpcConfig>> map = new HashMap<String, SdkField<DescribedWebAppVpcConfig>>();
        map.put("Vpc", VPC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribedWebAppEndpointDetails, T> g) {
        return obj -> g.apply((DescribedWebAppEndpointDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        VPC,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private DescribedWebAppVpcConfig vpc;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedWebAppEndpointDetails model) {
            this.vpc(model.vpc);
        }

        public final DescribedWebAppVpcConfig.Builder getVpc() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        public final void setVpc(DescribedWebAppVpcConfig.BuilderImpl vpc) {
            DescribedWebAppVpcConfig oldValue = this.vpc;
            this.vpc = vpc != null ? vpc.build() : null;
            this.handleUnionValueChange(Type.VPC, oldValue, this.vpc);
        }

        @Override
        public final Builder vpc(DescribedWebAppVpcConfig vpc) {
            DescribedWebAppVpcConfig oldValue = this.vpc;
            this.vpc = vpc;
            this.handleUnionValueChange(Type.VPC, oldValue, this.vpc);
            return this;
        }

        public DescribedWebAppEndpointDetails build() {
            return new DescribedWebAppEndpointDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribedWebAppEndpointDetails> {
        public Builder vpc(DescribedWebAppVpcConfig var1);

        default public Builder vpc(Consumer<DescribedWebAppVpcConfig.Builder> vpc) {
            return this.vpc((DescribedWebAppVpcConfig)((DescribedWebAppVpcConfig.Builder)DescribedWebAppVpcConfig.builder().applyMutation(vpc)).build());
        }
    }
}

