/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetParallelDataResponse extends TranslateResponse implements
        ToCopyableBuilder<GetParallelDataResponse.Builder, GetParallelDataResponse> {
    private static final SdkField<ParallelDataProperties> PARALLEL_DATA_PROPERTIES_FIELD = SdkField
            .<ParallelDataProperties> builder(MarshallingType.SDK_POJO).memberName("ParallelDataProperties")
            .getter(getter(GetParallelDataResponse::parallelDataProperties)).setter(setter(Builder::parallelDataProperties))
            .constructor(ParallelDataProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelDataProperties").build())
            .build();

    private static final SdkField<ParallelDataDataLocation> DATA_LOCATION_FIELD = SdkField
            .<ParallelDataDataLocation> builder(MarshallingType.SDK_POJO).memberName("DataLocation")
            .getter(getter(GetParallelDataResponse::dataLocation)).setter(setter(Builder::dataLocation))
            .constructor(ParallelDataDataLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLocation").build()).build();

    private static final SdkField<ParallelDataDataLocation> AUXILIARY_DATA_LOCATION_FIELD = SdkField
            .<ParallelDataDataLocation> builder(MarshallingType.SDK_POJO).memberName("AuxiliaryDataLocation")
            .getter(getter(GetParallelDataResponse::auxiliaryDataLocation)).setter(setter(Builder::auxiliaryDataLocation))
            .constructor(ParallelDataDataLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuxiliaryDataLocation").build())
            .build();

    private static final SdkField<ParallelDataDataLocation> LATEST_UPDATE_ATTEMPT_AUXILIARY_DATA_LOCATION_FIELD = SdkField
            .<ParallelDataDataLocation> builder(MarshallingType.SDK_POJO)
            .memberName("LatestUpdateAttemptAuxiliaryDataLocation")
            .getter(getter(GetParallelDataResponse::latestUpdateAttemptAuxiliaryDataLocation))
            .setter(setter(Builder::latestUpdateAttemptAuxiliaryDataLocation))
            .constructor(ParallelDataDataLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LatestUpdateAttemptAuxiliaryDataLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PARALLEL_DATA_PROPERTIES_FIELD, DATA_LOCATION_FIELD, AUXILIARY_DATA_LOCATION_FIELD,
            LATEST_UPDATE_ATTEMPT_AUXILIARY_DATA_LOCATION_FIELD));

    private final ParallelDataProperties parallelDataProperties;

    private final ParallelDataDataLocation dataLocation;

    private final ParallelDataDataLocation auxiliaryDataLocation;

    private final ParallelDataDataLocation latestUpdateAttemptAuxiliaryDataLocation;

    private GetParallelDataResponse(BuilderImpl builder) {
        super(builder);
        this.parallelDataProperties = builder.parallelDataProperties;
        this.dataLocation = builder.dataLocation;
        this.auxiliaryDataLocation = builder.auxiliaryDataLocation;
        this.latestUpdateAttemptAuxiliaryDataLocation = builder.latestUpdateAttemptAuxiliaryDataLocation;
    }

    /**
     * <p>
     * The properties of the parallel data resource that is being retrieved.
     * </p>
     * 
     * @return The properties of the parallel data resource that is being retrieved.
     */
    public final ParallelDataProperties parallelDataProperties() {
        return parallelDataProperties;
    }

    /**
     * <p>
     * The location of the most recent parallel data input file that was successfully imported into Amazon Translate.
     * The location is returned as a presigned URL that has a 30 minute expiration.
     * </p>
     * 
     * @return The location of the most recent parallel data input file that was successfully imported into Amazon
     *         Translate. The location is returned as a presigned URL that has a 30 minute expiration.
     */
    public final ParallelDataDataLocation dataLocation() {
        return dataLocation;
    }

    /**
     * <p>
     * The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file. This
     * file was created when Amazon Translate attempted to create a parallel data resource. The location is returned as
     * a presigned URL to that has a 30 minute expiration.
     * </p>
     * 
     * @return The Amazon S3 location of a file that provides any errors or warnings that were produced by your input
     *         file. This file was created when Amazon Translate attempted to create a parallel data resource. The
     *         location is returned as a presigned URL to that has a 30 minute expiration.
     */
    public final ParallelDataDataLocation auxiliaryDataLocation() {
        return auxiliaryDataLocation;
    }

    /**
     * <p>
     * The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file. This
     * file was created when Amazon Translate attempted to update a parallel data resource. The location is returned as
     * a presigned URL to that has a 30 minute expiration.
     * </p>
     * 
     * @return The Amazon S3 location of a file that provides any errors or warnings that were produced by your input
     *         file. This file was created when Amazon Translate attempted to update a parallel data resource. The
     *         location is returned as a presigned URL to that has a 30 minute expiration.
     */
    public final ParallelDataDataLocation latestUpdateAttemptAuxiliaryDataLocation() {
        return latestUpdateAttemptAuxiliaryDataLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(parallelDataProperties());
        hashCode = 31 * hashCode + Objects.hashCode(dataLocation());
        hashCode = 31 * hashCode + Objects.hashCode(auxiliaryDataLocation());
        hashCode = 31 * hashCode + Objects.hashCode(latestUpdateAttemptAuxiliaryDataLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParallelDataResponse)) {
            return false;
        }
        GetParallelDataResponse other = (GetParallelDataResponse) obj;
        return Objects.equals(parallelDataProperties(), other.parallelDataProperties())
                && Objects.equals(dataLocation(), other.dataLocation())
                && Objects.equals(auxiliaryDataLocation(), other.auxiliaryDataLocation())
                && Objects.equals(latestUpdateAttemptAuxiliaryDataLocation(), other.latestUpdateAttemptAuxiliaryDataLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetParallelDataResponse").add("ParallelDataProperties", parallelDataProperties())
                .add("DataLocation", dataLocation()).add("AuxiliaryDataLocation", auxiliaryDataLocation())
                .add("LatestUpdateAttemptAuxiliaryDataLocation", latestUpdateAttemptAuxiliaryDataLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParallelDataProperties":
            return Optional.ofNullable(clazz.cast(parallelDataProperties()));
        case "DataLocation":
            return Optional.ofNullable(clazz.cast(dataLocation()));
        case "AuxiliaryDataLocation":
            return Optional.ofNullable(clazz.cast(auxiliaryDataLocation()));
        case "LatestUpdateAttemptAuxiliaryDataLocation":
            return Optional.ofNullable(clazz.cast(latestUpdateAttemptAuxiliaryDataLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetParallelDataResponse, T> g) {
        return obj -> g.apply((GetParallelDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranslateResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetParallelDataResponse> {
        /**
         * <p>
         * The properties of the parallel data resource that is being retrieved.
         * </p>
         * 
         * @param parallelDataProperties
         *        The properties of the parallel data resource that is being retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelDataProperties(ParallelDataProperties parallelDataProperties);

        /**
         * <p>
         * The properties of the parallel data resource that is being retrieved.
         * </p>
         * This is a convenience that creates an instance of the {@link ParallelDataProperties.Builder} avoiding the
         * need to create one manually via {@link ParallelDataProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ParallelDataProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #parallelDataProperties(ParallelDataProperties)}.
         * 
         * @param parallelDataProperties
         *        a consumer that will call methods on {@link ParallelDataProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parallelDataProperties(ParallelDataProperties)
         */
        default Builder parallelDataProperties(Consumer<ParallelDataProperties.Builder> parallelDataProperties) {
            return parallelDataProperties(ParallelDataProperties.builder().applyMutation(parallelDataProperties).build());
        }

        /**
         * <p>
         * The location of the most recent parallel data input file that was successfully imported into Amazon
         * Translate. The location is returned as a presigned URL that has a 30 minute expiration.
         * </p>
         * 
         * @param dataLocation
         *        The location of the most recent parallel data input file that was successfully imported into Amazon
         *        Translate. The location is returned as a presigned URL that has a 30 minute expiration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLocation(ParallelDataDataLocation dataLocation);

        /**
         * <p>
         * The location of the most recent parallel data input file that was successfully imported into Amazon
         * Translate. The location is returned as a presigned URL that has a 30 minute expiration.
         * </p>
         * This is a convenience that creates an instance of the {@link ParallelDataDataLocation.Builder} avoiding the
         * need to create one manually via {@link ParallelDataDataLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link ParallelDataDataLocation.Builder#build()} is called immediately
         * and its result is passed to {@link #dataLocation(ParallelDataDataLocation)}.
         * 
         * @param dataLocation
         *        a consumer that will call methods on {@link ParallelDataDataLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataLocation(ParallelDataDataLocation)
         */
        default Builder dataLocation(Consumer<ParallelDataDataLocation.Builder> dataLocation) {
            return dataLocation(ParallelDataDataLocation.builder().applyMutation(dataLocation).build());
        }

        /**
         * <p>
         * The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file.
         * This file was created when Amazon Translate attempted to create a parallel data resource. The location is
         * returned as a presigned URL to that has a 30 minute expiration.
         * </p>
         * 
         * @param auxiliaryDataLocation
         *        The Amazon S3 location of a file that provides any errors or warnings that were produced by your input
         *        file. This file was created when Amazon Translate attempted to create a parallel data resource. The
         *        location is returned as a presigned URL to that has a 30 minute expiration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auxiliaryDataLocation(ParallelDataDataLocation auxiliaryDataLocation);

        /**
         * <p>
         * The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file.
         * This file was created when Amazon Translate attempted to create a parallel data resource. The location is
         * returned as a presigned URL to that has a 30 minute expiration.
         * </p>
         * This is a convenience that creates an instance of the {@link ParallelDataDataLocation.Builder} avoiding the
         * need to create one manually via {@link ParallelDataDataLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link ParallelDataDataLocation.Builder#build()} is called immediately
         * and its result is passed to {@link #auxiliaryDataLocation(ParallelDataDataLocation)}.
         * 
         * @param auxiliaryDataLocation
         *        a consumer that will call methods on {@link ParallelDataDataLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auxiliaryDataLocation(ParallelDataDataLocation)
         */
        default Builder auxiliaryDataLocation(Consumer<ParallelDataDataLocation.Builder> auxiliaryDataLocation) {
            return auxiliaryDataLocation(ParallelDataDataLocation.builder().applyMutation(auxiliaryDataLocation).build());
        }

        /**
         * <p>
         * The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file.
         * This file was created when Amazon Translate attempted to update a parallel data resource. The location is
         * returned as a presigned URL to that has a 30 minute expiration.
         * </p>
         * 
         * @param latestUpdateAttemptAuxiliaryDataLocation
         *        The Amazon S3 location of a file that provides any errors or warnings that were produced by your input
         *        file. This file was created when Amazon Translate attempted to update a parallel data resource. The
         *        location is returned as a presigned URL to that has a 30 minute expiration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestUpdateAttemptAuxiliaryDataLocation(ParallelDataDataLocation latestUpdateAttemptAuxiliaryDataLocation);

        /**
         * <p>
         * The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file.
         * This file was created when Amazon Translate attempted to update a parallel data resource. The location is
         * returned as a presigned URL to that has a 30 minute expiration.
         * </p>
         * This is a convenience that creates an instance of the {@link ParallelDataDataLocation.Builder} avoiding the
         * need to create one manually via {@link ParallelDataDataLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link ParallelDataDataLocation.Builder#build()} is called immediately
         * and its result is passed to {@link #latestUpdateAttemptAuxiliaryDataLocation(ParallelDataDataLocation)}.
         * 
         * @param latestUpdateAttemptAuxiliaryDataLocation
         *        a consumer that will call methods on {@link ParallelDataDataLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestUpdateAttemptAuxiliaryDataLocation(ParallelDataDataLocation)
         */
        default Builder latestUpdateAttemptAuxiliaryDataLocation(
                Consumer<ParallelDataDataLocation.Builder> latestUpdateAttemptAuxiliaryDataLocation) {
            return latestUpdateAttemptAuxiliaryDataLocation(ParallelDataDataLocation.builder()
                    .applyMutation(latestUpdateAttemptAuxiliaryDataLocation).build());
        }
    }

    static final class BuilderImpl extends TranslateResponse.BuilderImpl implements Builder {
        private ParallelDataProperties parallelDataProperties;

        private ParallelDataDataLocation dataLocation;

        private ParallelDataDataLocation auxiliaryDataLocation;

        private ParallelDataDataLocation latestUpdateAttemptAuxiliaryDataLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParallelDataResponse model) {
            super(model);
            parallelDataProperties(model.parallelDataProperties);
            dataLocation(model.dataLocation);
            auxiliaryDataLocation(model.auxiliaryDataLocation);
            latestUpdateAttemptAuxiliaryDataLocation(model.latestUpdateAttemptAuxiliaryDataLocation);
        }

        public final ParallelDataProperties.Builder getParallelDataProperties() {
            return parallelDataProperties != null ? parallelDataProperties.toBuilder() : null;
        }

        @Override
        public final Builder parallelDataProperties(ParallelDataProperties parallelDataProperties) {
            this.parallelDataProperties = parallelDataProperties;
            return this;
        }

        public final void setParallelDataProperties(ParallelDataProperties.BuilderImpl parallelDataProperties) {
            this.parallelDataProperties = parallelDataProperties != null ? parallelDataProperties.build() : null;
        }

        public final ParallelDataDataLocation.Builder getDataLocation() {
            return dataLocation != null ? dataLocation.toBuilder() : null;
        }

        @Override
        public final Builder dataLocation(ParallelDataDataLocation dataLocation) {
            this.dataLocation = dataLocation;
            return this;
        }

        public final void setDataLocation(ParallelDataDataLocation.BuilderImpl dataLocation) {
            this.dataLocation = dataLocation != null ? dataLocation.build() : null;
        }

        public final ParallelDataDataLocation.Builder getAuxiliaryDataLocation() {
            return auxiliaryDataLocation != null ? auxiliaryDataLocation.toBuilder() : null;
        }

        @Override
        public final Builder auxiliaryDataLocation(ParallelDataDataLocation auxiliaryDataLocation) {
            this.auxiliaryDataLocation = auxiliaryDataLocation;
            return this;
        }

        public final void setAuxiliaryDataLocation(ParallelDataDataLocation.BuilderImpl auxiliaryDataLocation) {
            this.auxiliaryDataLocation = auxiliaryDataLocation != null ? auxiliaryDataLocation.build() : null;
        }

        public final ParallelDataDataLocation.Builder getLatestUpdateAttemptAuxiliaryDataLocation() {
            return latestUpdateAttemptAuxiliaryDataLocation != null ? latestUpdateAttemptAuxiliaryDataLocation.toBuilder() : null;
        }

        @Override
        public final Builder latestUpdateAttemptAuxiliaryDataLocation(
                ParallelDataDataLocation latestUpdateAttemptAuxiliaryDataLocation) {
            this.latestUpdateAttemptAuxiliaryDataLocation = latestUpdateAttemptAuxiliaryDataLocation;
            return this;
        }

        public final void setLatestUpdateAttemptAuxiliaryDataLocation(
                ParallelDataDataLocation.BuilderImpl latestUpdateAttemptAuxiliaryDataLocation) {
            this.latestUpdateAttemptAuxiliaryDataLocation = latestUpdateAttemptAuxiliaryDataLocation != null ? latestUpdateAttemptAuxiliaryDataLocation
                    .build() : null;
        }

        @Override
        public GetParallelDataResponse build() {
            return new GetParallelDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
