/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TranslateTextResponse extends TranslateResponse implements
        ToCopyableBuilder<TranslateTextResponse.Builder, TranslateTextResponse> {
    private static final SdkField<String> TRANSLATED_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TranslatedText").getter(getter(TranslateTextResponse::translatedText))
            .setter(setter(Builder::translatedText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranslatedText").build()).build();

    private static final SdkField<String> SOURCE_LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLanguageCode").getter(getter(TranslateTextResponse::sourceLanguageCode))
            .setter(setter(Builder::sourceLanguageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLanguageCode").build())
            .build();

    private static final SdkField<String> TARGET_LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetLanguageCode").getter(getter(TranslateTextResponse::targetLanguageCode))
            .setter(setter(Builder::targetLanguageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLanguageCode").build())
            .build();

    private static final SdkField<List<AppliedTerminology>> APPLIED_TERMINOLOGIES_FIELD = SdkField
            .<List<AppliedTerminology>> builder(MarshallingType.LIST)
            .memberName("AppliedTerminologies")
            .getter(getter(TranslateTextResponse::appliedTerminologies))
            .setter(setter(Builder::appliedTerminologies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedTerminologies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppliedTerminology> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppliedTerminology::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TranslationSettings> APPLIED_SETTINGS_FIELD = SdkField
            .<TranslationSettings> builder(MarshallingType.SDK_POJO).memberName("AppliedSettings")
            .getter(getter(TranslateTextResponse::appliedSettings)).setter(setter(Builder::appliedSettings))
            .constructor(TranslationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSLATED_TEXT_FIELD,
            SOURCE_LANGUAGE_CODE_FIELD, TARGET_LANGUAGE_CODE_FIELD, APPLIED_TERMINOLOGIES_FIELD, APPLIED_SETTINGS_FIELD));

    private final String translatedText;

    private final String sourceLanguageCode;

    private final String targetLanguageCode;

    private final List<AppliedTerminology> appliedTerminologies;

    private final TranslationSettings appliedSettings;

    private TranslateTextResponse(BuilderImpl builder) {
        super(builder);
        this.translatedText = builder.translatedText;
        this.sourceLanguageCode = builder.sourceLanguageCode;
        this.targetLanguageCode = builder.targetLanguageCode;
        this.appliedTerminologies = builder.appliedTerminologies;
        this.appliedSettings = builder.appliedSettings;
    }

    /**
     * <p>
     * The translated text.
     * </p>
     * 
     * @return The translated text.
     */
    public final String translatedText() {
        return translatedText;
    }

    /**
     * <p>
     * The language code for the language of the source text.
     * </p>
     * 
     * @return The language code for the language of the source text.
     */
    public final String sourceLanguageCode() {
        return sourceLanguageCode;
    }

    /**
     * <p>
     * The language code for the language of the target text.
     * </p>
     * 
     * @return The language code for the language of the target text.
     */
    public final String targetLanguageCode() {
        return targetLanguageCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppliedTerminologies property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAppliedTerminologies() {
        return appliedTerminologies != null && !(appliedTerminologies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the custom terminologies applied to the input text by Amazon Translate for the translated text
     * response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppliedTerminologies} method.
     * </p>
     * 
     * @return The names of the custom terminologies applied to the input text by Amazon Translate for the translated
     *         text response.
     */
    public final List<AppliedTerminology> appliedTerminologies() {
        return appliedTerminologies;
    }

    /**
     * <p>
     * Optional settings that modify the translation output.
     * </p>
     * 
     * @return Optional settings that modify the translation output.
     */
    public final TranslationSettings appliedSettings() {
        return appliedSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(translatedText());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(targetLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasAppliedTerminologies() ? appliedTerminologies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(appliedSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslateTextResponse)) {
            return false;
        }
        TranslateTextResponse other = (TranslateTextResponse) obj;
        return Objects.equals(translatedText(), other.translatedText())
                && Objects.equals(sourceLanguageCode(), other.sourceLanguageCode())
                && Objects.equals(targetLanguageCode(), other.targetLanguageCode())
                && hasAppliedTerminologies() == other.hasAppliedTerminologies()
                && Objects.equals(appliedTerminologies(), other.appliedTerminologies())
                && Objects.equals(appliedSettings(), other.appliedSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TranslateTextResponse").add("TranslatedText", translatedText())
                .add("SourceLanguageCode", sourceLanguageCode()).add("TargetLanguageCode", targetLanguageCode())
                .add("AppliedTerminologies", hasAppliedTerminologies() ? appliedTerminologies() : null)
                .add("AppliedSettings", appliedSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TranslatedText":
            return Optional.ofNullable(clazz.cast(translatedText()));
        case "SourceLanguageCode":
            return Optional.ofNullable(clazz.cast(sourceLanguageCode()));
        case "TargetLanguageCode":
            return Optional.ofNullable(clazz.cast(targetLanguageCode()));
        case "AppliedTerminologies":
            return Optional.ofNullable(clazz.cast(appliedTerminologies()));
        case "AppliedSettings":
            return Optional.ofNullable(clazz.cast(appliedSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TranslateTextResponse, T> g) {
        return obj -> g.apply((TranslateTextResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranslateResponse.Builder, SdkPojo, CopyableBuilder<Builder, TranslateTextResponse> {
        /**
         * <p>
         * The translated text.
         * </p>
         * 
         * @param translatedText
         *        The translated text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder translatedText(String translatedText);

        /**
         * <p>
         * The language code for the language of the source text.
         * </p>
         * 
         * @param sourceLanguageCode
         *        The language code for the language of the source text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLanguageCode(String sourceLanguageCode);

        /**
         * <p>
         * The language code for the language of the target text.
         * </p>
         * 
         * @param targetLanguageCode
         *        The language code for the language of the target text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLanguageCode(String targetLanguageCode);

        /**
         * <p>
         * The names of the custom terminologies applied to the input text by Amazon Translate for the translated text
         * response.
         * </p>
         * 
         * @param appliedTerminologies
         *        The names of the custom terminologies applied to the input text by Amazon Translate for the translated
         *        text response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedTerminologies(Collection<AppliedTerminology> appliedTerminologies);

        /**
         * <p>
         * The names of the custom terminologies applied to the input text by Amazon Translate for the translated text
         * response.
         * </p>
         * 
         * @param appliedTerminologies
         *        The names of the custom terminologies applied to the input text by Amazon Translate for the translated
         *        text response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedTerminologies(AppliedTerminology... appliedTerminologies);

        /**
         * <p>
         * The names of the custom terminologies applied to the input text by Amazon Translate for the translated text
         * response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.translate.model.AppliedTerminology.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.translate.model.AppliedTerminology#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.translate.model.AppliedTerminology.Builder#build()} is called
         * immediately and its result is passed to {@link #appliedTerminologies(List<AppliedTerminology>)}.
         * 
         * @param appliedTerminologies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.translate.model.AppliedTerminology.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appliedTerminologies(java.util.Collection<AppliedTerminology>)
         */
        Builder appliedTerminologies(Consumer<AppliedTerminology.Builder>... appliedTerminologies);

        /**
         * <p>
         * Optional settings that modify the translation output.
         * </p>
         * 
         * @param appliedSettings
         *        Optional settings that modify the translation output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedSettings(TranslationSettings appliedSettings);

        /**
         * <p>
         * Optional settings that modify the translation output.
         * </p>
         * This is a convenience method that creates an instance of the {@link TranslationSettings.Builder} avoiding the
         * need to create one manually via {@link TranslationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TranslationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #appliedSettings(TranslationSettings)}.
         * 
         * @param appliedSettings
         *        a consumer that will call methods on {@link TranslationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appliedSettings(TranslationSettings)
         */
        default Builder appliedSettings(Consumer<TranslationSettings.Builder> appliedSettings) {
            return appliedSettings(TranslationSettings.builder().applyMutation(appliedSettings).build());
        }
    }

    static final class BuilderImpl extends TranslateResponse.BuilderImpl implements Builder {
        private String translatedText;

        private String sourceLanguageCode;

        private String targetLanguageCode;

        private List<AppliedTerminology> appliedTerminologies = DefaultSdkAutoConstructList.getInstance();

        private TranslationSettings appliedSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(TranslateTextResponse model) {
            super(model);
            translatedText(model.translatedText);
            sourceLanguageCode(model.sourceLanguageCode);
            targetLanguageCode(model.targetLanguageCode);
            appliedTerminologies(model.appliedTerminologies);
            appliedSettings(model.appliedSettings);
        }

        public final String getTranslatedText() {
            return translatedText;
        }

        public final void setTranslatedText(String translatedText) {
            this.translatedText = translatedText;
        }

        @Override
        public final Builder translatedText(String translatedText) {
            this.translatedText = translatedText;
            return this;
        }

        public final String getSourceLanguageCode() {
            return sourceLanguageCode;
        }

        public final void setSourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
        }

        @Override
        public final Builder sourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
            return this;
        }

        public final String getTargetLanguageCode() {
            return targetLanguageCode;
        }

        public final void setTargetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
        }

        @Override
        public final Builder targetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
            return this;
        }

        public final List<AppliedTerminology.Builder> getAppliedTerminologies() {
            List<AppliedTerminology.Builder> result = AppliedTerminologyListCopier.copyToBuilder(this.appliedTerminologies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppliedTerminologies(Collection<AppliedTerminology.BuilderImpl> appliedTerminologies) {
            this.appliedTerminologies = AppliedTerminologyListCopier.copyFromBuilder(appliedTerminologies);
        }

        @Override
        public final Builder appliedTerminologies(Collection<AppliedTerminology> appliedTerminologies) {
            this.appliedTerminologies = AppliedTerminologyListCopier.copy(appliedTerminologies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appliedTerminologies(AppliedTerminology... appliedTerminologies) {
            appliedTerminologies(Arrays.asList(appliedTerminologies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appliedTerminologies(Consumer<AppliedTerminology.Builder>... appliedTerminologies) {
            appliedTerminologies(Stream.of(appliedTerminologies).map(c -> AppliedTerminology.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TranslationSettings.Builder getAppliedSettings() {
            return appliedSettings != null ? appliedSettings.toBuilder() : null;
        }

        public final void setAppliedSettings(TranslationSettings.BuilderImpl appliedSettings) {
            this.appliedSettings = appliedSettings != null ? appliedSettings.build() : null;
        }

        @Override
        public final Builder appliedSettings(TranslationSettings appliedSettings) {
            this.appliedSettings = appliedSettings;
            return this;
        }

        @Override
        public TranslateTextResponse build() {
            return new TranslateTextResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
