/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportTerminologyRequest extends TranslateRequest implements
        ToCopyableBuilder<ImportTerminologyRequest.Builder, ImportTerminologyRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ImportTerminologyRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> MERGE_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MergeStrategy").getter(getter(ImportTerminologyRequest::mergeStrategyAsString))
            .setter(setter(Builder::mergeStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeStrategy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ImportTerminologyRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<TerminologyData> TERMINOLOGY_DATA_FIELD = SdkField
            .<TerminologyData> builder(MarshallingType.SDK_POJO).memberName("TerminologyData")
            .getter(getter(ImportTerminologyRequest::terminologyData)).setter(setter(Builder::terminologyData))
            .constructor(TerminologyData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminologyData").build()).build();

    private static final SdkField<EncryptionKey> ENCRYPTION_KEY_FIELD = SdkField
            .<EncryptionKey> builder(MarshallingType.SDK_POJO).memberName("EncryptionKey")
            .getter(getter(ImportTerminologyRequest::encryptionKey)).setter(setter(Builder::encryptionKey))
            .constructor(EncryptionKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKey").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ImportTerminologyRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            MERGE_STRATEGY_FIELD, DESCRIPTION_FIELD, TERMINOLOGY_DATA_FIELD, ENCRYPTION_KEY_FIELD, TAGS_FIELD));

    private final String name;

    private final String mergeStrategy;

    private final String description;

    private final TerminologyData terminologyData;

    private final EncryptionKey encryptionKey;

    private final List<Tag> tags;

    private ImportTerminologyRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.mergeStrategy = builder.mergeStrategy;
        this.description = builder.description;
        this.terminologyData = builder.terminologyData;
        this.encryptionKey = builder.encryptionKey;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the custom terminology being imported.
     * </p>
     * 
     * @return The name of the custom terminology being imported.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy is
     * supported. In this case, the imported terminology will overwrite an existing terminology of the same name.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy
     *         is supported. In this case, the imported terminology will overwrite an existing terminology of the same
     *         name.
     * @see MergeStrategy
     */
    public final MergeStrategy mergeStrategy() {
        return MergeStrategy.fromValue(mergeStrategy);
    }

    /**
     * <p>
     * The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy is
     * supported. In this case, the imported terminology will overwrite an existing terminology of the same name.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy
     *         is supported. In this case, the imported terminology will overwrite an existing terminology of the same
     *         name.
     * @see MergeStrategy
     */
    public final String mergeStrategyAsString() {
        return mergeStrategy;
    }

    /**
     * <p>
     * The description of the custom terminology being imported.
     * </p>
     * 
     * @return The description of the custom terminology being imported.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The terminology data for the custom terminology being imported.
     * </p>
     * 
     * @return The terminology data for the custom terminology being imported.
     */
    public final TerminologyData terminologyData() {
        return terminologyData;
    }

    /**
     * <p>
     * The encryption key for the custom terminology being imported.
     * </p>
     * 
     * @return The encryption key for the custom terminology being imported.
     */
    public final EncryptionKey encryptionKey() {
        return encryptionKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to be associated with this resource. A tag is a key-value pair that adds metadata to a resource. Each tag
     * key for the resource must be unique. For more information, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to be associated with this resource. A tag is a key-value pair that adds metadata to a resource.
     *         Each tag key for the resource must be unique. For more information, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(mergeStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(terminologyData());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTerminologyRequest)) {
            return false;
        }
        ImportTerminologyRequest other = (ImportTerminologyRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(mergeStrategyAsString(), other.mergeStrategyAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(terminologyData(), other.terminologyData())
                && Objects.equals(encryptionKey(), other.encryptionKey()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportTerminologyRequest").add("Name", name()).add("MergeStrategy", mergeStrategyAsString())
                .add("Description", description()).add("TerminologyData", terminologyData())
                .add("EncryptionKey", encryptionKey()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "MergeStrategy":
            return Optional.ofNullable(clazz.cast(mergeStrategyAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "TerminologyData":
            return Optional.ofNullable(clazz.cast(terminologyData()));
        case "EncryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportTerminologyRequest, T> g) {
        return obj -> g.apply((ImportTerminologyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranslateRequest.Builder, SdkPojo, CopyableBuilder<Builder, ImportTerminologyRequest> {
        /**
         * <p>
         * The name of the custom terminology being imported.
         * </p>
         * 
         * @param name
         *        The name of the custom terminology being imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy is
         * supported. In this case, the imported terminology will overwrite an existing terminology of the same name.
         * </p>
         * 
         * @param mergeStrategy
         *        The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge
         *        strategy is supported. In this case, the imported terminology will overwrite an existing terminology
         *        of the same name.
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(String mergeStrategy);

        /**
         * <p>
         * The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy is
         * supported. In this case, the imported terminology will overwrite an existing terminology of the same name.
         * </p>
         * 
         * @param mergeStrategy
         *        The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge
         *        strategy is supported. In this case, the imported terminology will overwrite an existing terminology
         *        of the same name.
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(MergeStrategy mergeStrategy);

        /**
         * <p>
         * The description of the custom terminology being imported.
         * </p>
         * 
         * @param description
         *        The description of the custom terminology being imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The terminology data for the custom terminology being imported.
         * </p>
         * 
         * @param terminologyData
         *        The terminology data for the custom terminology being imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminologyData(TerminologyData terminologyData);

        /**
         * <p>
         * The terminology data for the custom terminology being imported.
         * </p>
         * This is a convenience method that creates an instance of the {@link TerminologyData.Builder} avoiding the
         * need to create one manually via {@link TerminologyData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TerminologyData.Builder#build()} is called immediately and its
         * result is passed to {@link #terminologyData(TerminologyData)}.
         * 
         * @param terminologyData
         *        a consumer that will call methods on {@link TerminologyData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terminologyData(TerminologyData)
         */
        default Builder terminologyData(Consumer<TerminologyData.Builder> terminologyData) {
            return terminologyData(TerminologyData.builder().applyMutation(terminologyData).build());
        }

        /**
         * <p>
         * The encryption key for the custom terminology being imported.
         * </p>
         * 
         * @param encryptionKey
         *        The encryption key for the custom terminology being imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(EncryptionKey encryptionKey);

        /**
         * <p>
         * The encryption key for the custom terminology being imported.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionKey.Builder} avoiding the need
         * to create one manually via {@link EncryptionKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionKey.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionKey(EncryptionKey)}.
         * 
         * @param encryptionKey
         *        a consumer that will call methods on {@link EncryptionKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionKey(EncryptionKey)
         */
        default Builder encryptionKey(Consumer<EncryptionKey.Builder> encryptionKey) {
            return encryptionKey(EncryptionKey.builder().applyMutation(encryptionKey).build());
        }

        /**
         * <p>
         * Tags to be associated with this resource. A tag is a key-value pair that adds metadata to a resource. Each
         * tag key for the resource must be unique. For more information, see <a
         * href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
         * </p>
         * 
         * @param tags
         *        Tags to be associated with this resource. A tag is a key-value pair that adds metadata to a resource.
         *        Each tag key for the resource must be unique. For more information, see <a
         *        href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags to be associated with this resource. A tag is a key-value pair that adds metadata to a resource. Each
         * tag key for the resource must be unique. For more information, see <a
         * href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
         * </p>
         * 
         * @param tags
         *        Tags to be associated with this resource. A tag is a key-value pair that adds metadata to a resource.
         *        Each tag key for the resource must be unique. For more information, see <a
         *        href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags to be associated with this resource. A tag is a key-value pair that adds metadata to a resource. Each
         * tag key for the resource must be unique. For more information, see <a
         * href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.translate.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.translate.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.translate.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.translate.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranslateRequest.BuilderImpl implements Builder {
        private String name;

        private String mergeStrategy;

        private String description;

        private TerminologyData terminologyData;

        private EncryptionKey encryptionKey;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportTerminologyRequest model) {
            super(model);
            name(model.name);
            mergeStrategy(model.mergeStrategy);
            description(model.description);
            terminologyData(model.terminologyData);
            encryptionKey(model.encryptionKey);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMergeStrategy() {
            return mergeStrategy;
        }

        public final void setMergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
        }

        @Override
        public final Builder mergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            return this;
        }

        @Override
        public final Builder mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy(mergeStrategy == null ? null : mergeStrategy.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final TerminologyData.Builder getTerminologyData() {
            return terminologyData != null ? terminologyData.toBuilder() : null;
        }

        public final void setTerminologyData(TerminologyData.BuilderImpl terminologyData) {
            this.terminologyData = terminologyData != null ? terminologyData.build() : null;
        }

        @Override
        public final Builder terminologyData(TerminologyData terminologyData) {
            this.terminologyData = terminologyData;
            return this;
        }

        public final EncryptionKey.Builder getEncryptionKey() {
            return encryptionKey != null ? encryptionKey.toBuilder() : null;
        }

        public final void setEncryptionKey(EncryptionKey.BuilderImpl encryptionKey) {
            this.encryptionKey = encryptionKey != null ? encryptionKey.build() : null;
        }

        @Override
        public final Builder encryptionKey(EncryptionKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportTerminologyRequest build() {
            return new ImportTerminologyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
