/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ParallelDataFormat {
    TSV("TSV"),
    CSV("CSV"),
    TMX("TMX"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ParallelDataFormat> VALUE_MAP;
    private final String value;

    private ParallelDataFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ParallelDataFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ParallelDataFormat> knownValues() {
        EnumSet<ParallelDataFormat> knownValues = EnumSet.allOf(ParallelDataFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ParallelDataFormat.class, ParallelDataFormat::toString);
    }
}

