/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.trustedadvisor.model.OrganizationRecommendationSummary;
import software.amazon.awssdk.services.trustedadvisor.model.OrganizationRecommendationSummaryListCopier;
import software.amazon.awssdk.services.trustedadvisor.model.TrustedAdvisorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOrganizationRecommendationsResponse
extends TrustedAdvisorResponse
implements ToCopyableBuilder<Builder, ListOrganizationRecommendationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListOrganizationRecommendationsResponse.getter(ListOrganizationRecommendationsResponse::nextToken)).setter(ListOrganizationRecommendationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<OrganizationRecommendationSummary>> ORGANIZATION_RECOMMENDATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("organizationRecommendationSummaries").getter(ListOrganizationRecommendationsResponse.getter(ListOrganizationRecommendationsResponse::organizationRecommendationSummaries)).setter(ListOrganizationRecommendationsResponse.setter(Builder::organizationRecommendationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationRecommendationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrganizationRecommendationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ORGANIZATION_RECOMMENDATION_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListOrganizationRecommendationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<OrganizationRecommendationSummary> organizationRecommendationSummaries;

    private ListOrganizationRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.organizationRecommendationSummaries = builder.organizationRecommendationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasOrganizationRecommendationSummaries() {
        return this.organizationRecommendationSummaries != null && !(this.organizationRecommendationSummaries instanceof SdkAutoConstructList);
    }

    public final List<OrganizationRecommendationSummary> organizationRecommendationSummaries() {
        return this.organizationRecommendationSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationRecommendationSummaries() ? this.organizationRecommendationSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationRecommendationsResponse)) {
            return false;
        }
        ListOrganizationRecommendationsResponse other = (ListOrganizationRecommendationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasOrganizationRecommendationSummaries() == other.hasOrganizationRecommendationSummaries() && Objects.equals(this.organizationRecommendationSummaries(), other.organizationRecommendationSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListOrganizationRecommendationsResponse").add("NextToken", (Object)this.nextToken()).add("OrganizationRecommendationSummaries", this.hasOrganizationRecommendationSummaries() ? this.organizationRecommendationSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "organizationRecommendationSummaries": {
                return Optional.ofNullable(clazz.cast(this.organizationRecommendationSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("organizationRecommendationSummaries", ORGANIZATION_RECOMMENDATION_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOrganizationRecommendationsResponse, T> g) {
        return obj -> g.apply((ListOrganizationRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TrustedAdvisorResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<OrganizationRecommendationSummary> organizationRecommendationSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationRecommendationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.organizationRecommendationSummaries(model.organizationRecommendationSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<OrganizationRecommendationSummary.Builder> getOrganizationRecommendationSummaries() {
            List<OrganizationRecommendationSummary.Builder> result = OrganizationRecommendationSummaryListCopier.copyToBuilder(this.organizationRecommendationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrganizationRecommendationSummaries(Collection<OrganizationRecommendationSummary.BuilderImpl> organizationRecommendationSummaries) {
            this.organizationRecommendationSummaries = OrganizationRecommendationSummaryListCopier.copyFromBuilder(organizationRecommendationSummaries);
        }

        @Override
        public final Builder organizationRecommendationSummaries(Collection<OrganizationRecommendationSummary> organizationRecommendationSummaries) {
            this.organizationRecommendationSummaries = OrganizationRecommendationSummaryListCopier.copy(organizationRecommendationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationRecommendationSummaries(OrganizationRecommendationSummary ... organizationRecommendationSummaries) {
            this.organizationRecommendationSummaries(Arrays.asList(organizationRecommendationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationRecommendationSummaries(Consumer<OrganizationRecommendationSummary.Builder> ... organizationRecommendationSummaries) {
            this.organizationRecommendationSummaries(Stream.of(organizationRecommendationSummaries).map(c -> (OrganizationRecommendationSummary)((OrganizationRecommendationSummary.Builder)OrganizationRecommendationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListOrganizationRecommendationsResponse build() {
            return new ListOrganizationRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TrustedAdvisorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOrganizationRecommendationsResponse> {
        public Builder nextToken(String var1);

        public Builder organizationRecommendationSummaries(Collection<OrganizationRecommendationSummary> var1);

        public Builder organizationRecommendationSummaries(OrganizationRecommendationSummary ... var1);

        public Builder organizationRecommendationSummaries(Consumer<OrganizationRecommendationSummary.Builder> ... var1);
    }
}

