/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils.internal;

import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.OptionalUtils;
import software.amazon.awssdk.utils.SystemSetting;
import software.amazon.awssdk.utils.internal.SystemSettingUtilsTestBackdoor;

@SdkProtectedApi
public final class SystemSettingUtils {
    private static final Logger LOG = Logger.loggerFor(SystemSettingUtils.class);

    private SystemSettingUtils() {
    }

    public static Optional<String> resolveSetting(SystemSetting setting) {
        return OptionalUtils.firstPresent(SystemSettingUtils.resolveProperty(setting), () -> SystemSettingUtils.resolveEnvironmentVariable(setting), () -> SystemSettingUtils.resolveDefault(setting)).map(String::trim);
    }

    public static Optional<String> resolveNonDefaultSetting(SystemSetting setting) {
        return OptionalUtils.firstPresent(SystemSettingUtils.resolveProperty(setting), new Supplier[]{() -> SystemSettingUtils.resolveEnvironmentVariable(setting)}).map(String::trim);
    }

    private static Optional<String> resolveProperty(SystemSetting setting) {
        return Optional.ofNullable(setting.property()).map(System::getProperty);
    }

    public static Optional<String> resolveEnvironmentVariable(SystemSetting setting) {
        return SystemSettingUtils.resolveEnvironmentVariable(setting.environmentVariable());
    }

    public static Optional<String> resolveEnvironmentVariable(String key) {
        try {
            return Optional.ofNullable(key).map(SystemSettingUtilsTestBackdoor::getEnvironmentVariable);
        }
        catch (SecurityException e) {
            LOG.debug(() -> String.format("Unable to load the environment variable %s because the security manager did not allow the SDK to read this system property. This setting will be assumed to be null", key), e);
            return Optional.empty();
        }
    }

    private static Optional<String> resolveDefault(SystemSetting setting) {
        return Optional.ofNullable(setting.defaultValue());
    }

    public static Boolean safeStringToBoolean(SystemSetting setting, String value) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalStateException("Environment variable '" + setting.environmentVariable() + "' or system property '" + setting.property() + "' was defined as '" + value + "', but should be 'false' or 'true'");
    }
}

