/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.verifiedpermissions.model.CognitoUserPoolConfigurationDetail;
import software.amazon.awssdk.services.verifiedpermissions.model.OpenIdConnectConfigurationDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationDetail> {
    private static final SdkField<CognitoUserPoolConfigurationDetail> COGNITO_USER_POOL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cognitoUserPoolConfiguration").getter(ConfigurationDetail.getter(ConfigurationDetail::cognitoUserPoolConfiguration)).setter(ConfigurationDetail.setter(Builder::cognitoUserPoolConfiguration)).constructor(CognitoUserPoolConfigurationDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cognitoUserPoolConfiguration").build()}).build();
    private static final SdkField<OpenIdConnectConfigurationDetail> OPEN_ID_CONNECT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("openIdConnectConfiguration").getter(ConfigurationDetail.getter(ConfigurationDetail::openIdConnectConfiguration)).setter(ConfigurationDetail.setter(Builder::openIdConnectConfiguration)).constructor(OpenIdConnectConfigurationDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIdConnectConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COGNITO_USER_POOL_CONFIGURATION_FIELD, OPEN_ID_CONNECT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurationDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CognitoUserPoolConfigurationDetail cognitoUserPoolConfiguration;
    private final OpenIdConnectConfigurationDetail openIdConnectConfiguration;
    private final Type type;

    private ConfigurationDetail(BuilderImpl builder) {
        this.cognitoUserPoolConfiguration = builder.cognitoUserPoolConfiguration;
        this.openIdConnectConfiguration = builder.openIdConnectConfiguration;
        this.type = builder.type;
    }

    public final CognitoUserPoolConfigurationDetail cognitoUserPoolConfiguration() {
        return this.cognitoUserPoolConfiguration;
    }

    public final OpenIdConnectConfigurationDetail openIdConnectConfiguration() {
        return this.openIdConnectConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoUserPoolConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.openIdConnectConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationDetail)) {
            return false;
        }
        ConfigurationDetail other = (ConfigurationDetail)obj;
        return Objects.equals(this.cognitoUserPoolConfiguration(), other.cognitoUserPoolConfiguration()) && Objects.equals(this.openIdConnectConfiguration(), other.openIdConnectConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationDetail").add("CognitoUserPoolConfiguration", (Object)this.cognitoUserPoolConfiguration()).add("OpenIdConnectConfiguration", (Object)this.openIdConnectConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cognitoUserPoolConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cognitoUserPoolConfiguration()));
            }
            case "openIdConnectConfiguration": {
                return Optional.ofNullable(clazz.cast(this.openIdConnectConfiguration()));
            }
        }
        return Optional.empty();
    }

    public static ConfigurationDetail fromCognitoUserPoolConfiguration(CognitoUserPoolConfigurationDetail cognitoUserPoolConfiguration) {
        return (ConfigurationDetail)ConfigurationDetail.builder().cognitoUserPoolConfiguration(cognitoUserPoolConfiguration).build();
    }

    public static ConfigurationDetail fromCognitoUserPoolConfiguration(Consumer<CognitoUserPoolConfigurationDetail.Builder> cognitoUserPoolConfiguration) {
        CognitoUserPoolConfigurationDetail.Builder builder = CognitoUserPoolConfigurationDetail.builder();
        cognitoUserPoolConfiguration.accept(builder);
        return ConfigurationDetail.fromCognitoUserPoolConfiguration((CognitoUserPoolConfigurationDetail)builder.build());
    }

    public static ConfigurationDetail fromOpenIdConnectConfiguration(OpenIdConnectConfigurationDetail openIdConnectConfiguration) {
        return (ConfigurationDetail)ConfigurationDetail.builder().openIdConnectConfiguration(openIdConnectConfiguration).build();
    }

    public static ConfigurationDetail fromOpenIdConnectConfiguration(Consumer<OpenIdConnectConfigurationDetail.Builder> openIdConnectConfiguration) {
        OpenIdConnectConfigurationDetail.Builder builder = OpenIdConnectConfigurationDetail.builder();
        openIdConnectConfiguration.accept(builder);
        return ConfigurationDetail.fromOpenIdConnectConfiguration((OpenIdConnectConfigurationDetail)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cognitoUserPoolConfiguration", COGNITO_USER_POOL_CONFIGURATION_FIELD);
        map.put("openIdConnectConfiguration", OPEN_ID_CONNECT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationDetail, T> g) {
        return obj -> g.apply((ConfigurationDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        COGNITO_USER_POOL_CONFIGURATION,
        OPEN_ID_CONNECT_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private CognitoUserPoolConfigurationDetail cognitoUserPoolConfiguration;
        private OpenIdConnectConfigurationDetail openIdConnectConfiguration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationDetail model) {
            this.cognitoUserPoolConfiguration(model.cognitoUserPoolConfiguration);
            this.openIdConnectConfiguration(model.openIdConnectConfiguration);
        }

        public final CognitoUserPoolConfigurationDetail.Builder getCognitoUserPoolConfiguration() {
            return this.cognitoUserPoolConfiguration != null ? this.cognitoUserPoolConfiguration.toBuilder() : null;
        }

        public final void setCognitoUserPoolConfiguration(CognitoUserPoolConfigurationDetail.BuilderImpl cognitoUserPoolConfiguration) {
            CognitoUserPoolConfigurationDetail oldValue = this.cognitoUserPoolConfiguration;
            this.cognitoUserPoolConfiguration = cognitoUserPoolConfiguration != null ? cognitoUserPoolConfiguration.build() : null;
            this.handleUnionValueChange(Type.COGNITO_USER_POOL_CONFIGURATION, oldValue, this.cognitoUserPoolConfiguration);
        }

        @Override
        public final Builder cognitoUserPoolConfiguration(CognitoUserPoolConfigurationDetail cognitoUserPoolConfiguration) {
            CognitoUserPoolConfigurationDetail oldValue = this.cognitoUserPoolConfiguration;
            this.cognitoUserPoolConfiguration = cognitoUserPoolConfiguration;
            this.handleUnionValueChange(Type.COGNITO_USER_POOL_CONFIGURATION, oldValue, this.cognitoUserPoolConfiguration);
            return this;
        }

        public final OpenIdConnectConfigurationDetail.Builder getOpenIdConnectConfiguration() {
            return this.openIdConnectConfiguration != null ? this.openIdConnectConfiguration.toBuilder() : null;
        }

        public final void setOpenIdConnectConfiguration(OpenIdConnectConfigurationDetail.BuilderImpl openIdConnectConfiguration) {
            OpenIdConnectConfigurationDetail oldValue = this.openIdConnectConfiguration;
            this.openIdConnectConfiguration = openIdConnectConfiguration != null ? openIdConnectConfiguration.build() : null;
            this.handleUnionValueChange(Type.OPEN_ID_CONNECT_CONFIGURATION, oldValue, this.openIdConnectConfiguration);
        }

        @Override
        public final Builder openIdConnectConfiguration(OpenIdConnectConfigurationDetail openIdConnectConfiguration) {
            OpenIdConnectConfigurationDetail oldValue = this.openIdConnectConfiguration;
            this.openIdConnectConfiguration = openIdConnectConfiguration;
            this.handleUnionValueChange(Type.OPEN_ID_CONNECT_CONFIGURATION, oldValue, this.openIdConnectConfiguration);
            return this;
        }

        public ConfigurationDetail build() {
            return new ConfigurationDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationDetail> {
        public Builder cognitoUserPoolConfiguration(CognitoUserPoolConfigurationDetail var1);

        default public Builder cognitoUserPoolConfiguration(Consumer<CognitoUserPoolConfigurationDetail.Builder> cognitoUserPoolConfiguration) {
            return this.cognitoUserPoolConfiguration((CognitoUserPoolConfigurationDetail)((CognitoUserPoolConfigurationDetail.Builder)CognitoUserPoolConfigurationDetail.builder().applyMutation(cognitoUserPoolConfiguration)).build());
        }

        public Builder openIdConnectConfiguration(OpenIdConnectConfigurationDetail var1);

        default public Builder openIdConnectConfiguration(Consumer<OpenIdConnectConfigurationDetail.Builder> openIdConnectConfiguration) {
            return this.openIdConnectConfiguration((OpenIdConnectConfigurationDetail)((OpenIdConnectConfigurationDetail.Builder)OpenIdConnectConfigurationDetail.builder().applyMutation(openIdConnectConfiguration)).build());
        }
    }
}

