/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.voiceid.model.SpeakerEnrollmentJobSummariesCopier;
import software.amazon.awssdk.services.voiceid.model.SpeakerEnrollmentJobSummary;
import software.amazon.awssdk.services.voiceid.model.VoiceIdResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSpeakerEnrollmentJobsResponse
extends VoiceIdResponse
implements ToCopyableBuilder<Builder, ListSpeakerEnrollmentJobsResponse> {
    private static final SdkField<List<SpeakerEnrollmentJobSummary>> JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JobSummaries").getter(ListSpeakerEnrollmentJobsResponse.getter(ListSpeakerEnrollmentJobsResponse::jobSummaries)).setter(ListSpeakerEnrollmentJobsResponse.setter(Builder::jobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SpeakerEnrollmentJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSpeakerEnrollmentJobsResponse.getter(ListSpeakerEnrollmentJobsResponse::nextToken)).setter(ListSpeakerEnrollmentJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSpeakerEnrollmentJobsResponse.memberNameToFieldInitializer();
    private final List<SpeakerEnrollmentJobSummary> jobSummaries;
    private final String nextToken;

    private ListSpeakerEnrollmentJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobSummaries = builder.jobSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasJobSummaries() {
        return this.jobSummaries != null && !(this.jobSummaries instanceof SdkAutoConstructList);
    }

    public final List<SpeakerEnrollmentJobSummary> jobSummaries() {
        return this.jobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobSummaries() ? this.jobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSpeakerEnrollmentJobsResponse)) {
            return false;
        }
        ListSpeakerEnrollmentJobsResponse other = (ListSpeakerEnrollmentJobsResponse)((Object)obj);
        return this.hasJobSummaries() == other.hasJobSummaries() && Objects.equals(this.jobSummaries(), other.jobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSpeakerEnrollmentJobsResponse").add("JobSummaries", this.hasJobSummaries() ? this.jobSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobSummaries": {
                return Optional.ofNullable(clazz.cast(this.jobSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobSummaries", JOB_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSpeakerEnrollmentJobsResponse, T> g) {
        return obj -> g.apply((ListSpeakerEnrollmentJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VoiceIdResponse.BuilderImpl
    implements Builder {
        private List<SpeakerEnrollmentJobSummary> jobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSpeakerEnrollmentJobsResponse model) {
            super(model);
            this.jobSummaries(model.jobSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<SpeakerEnrollmentJobSummary.Builder> getJobSummaries() {
            List<SpeakerEnrollmentJobSummary.Builder> result = SpeakerEnrollmentJobSummariesCopier.copyToBuilder(this.jobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobSummaries(Collection<SpeakerEnrollmentJobSummary.BuilderImpl> jobSummaries) {
            this.jobSummaries = SpeakerEnrollmentJobSummariesCopier.copyFromBuilder(jobSummaries);
        }

        @Override
        public final Builder jobSummaries(Collection<SpeakerEnrollmentJobSummary> jobSummaries) {
            this.jobSummaries = SpeakerEnrollmentJobSummariesCopier.copy(jobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobSummaries(SpeakerEnrollmentJobSummary ... jobSummaries) {
            this.jobSummaries(Arrays.asList(jobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobSummaries(Consumer<SpeakerEnrollmentJobSummary.Builder> ... jobSummaries) {
            this.jobSummaries(Stream.of(jobSummaries).map(c -> (SpeakerEnrollmentJobSummary)((SpeakerEnrollmentJobSummary.Builder)SpeakerEnrollmentJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSpeakerEnrollmentJobsResponse build() {
            return new ListSpeakerEnrollmentJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VoiceIdResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSpeakerEnrollmentJobsResponse> {
        public Builder jobSummaries(Collection<SpeakerEnrollmentJobSummary> var1);

        public Builder jobSummaries(SpeakerEnrollmentJobSummary ... var1);

        public Builder jobSummaries(Consumer<SpeakerEnrollmentJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

