/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeAsyncClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.DomainVerificationSummary;
import software.amazon.awssdk.services.vpclattice.model.ListDomainVerificationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListDomainVerificationsResponse;

public class ListDomainVerificationsPublisher
implements SdkPublisher<ListDomainVerificationsResponse> {
    private final VpcLatticeAsyncClient client;
    private final ListDomainVerificationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDomainVerificationsPublisher(VpcLatticeAsyncClient client, ListDomainVerificationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDomainVerificationsPublisher(VpcLatticeAsyncClient client, ListDomainVerificationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDomainVerificationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDomainVerificationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DomainVerificationSummary> items() {
        Function<ListDomainVerificationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDomainVerificationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDomainVerificationsResponseFetcher
    implements AsyncPageFetcher<ListDomainVerificationsResponse> {
        private ListDomainVerificationsResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainVerificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDomainVerificationsResponse> nextPage(ListDomainVerificationsResponse previousPage) {
            if (previousPage == null) {
                return ListDomainVerificationsPublisher.this.client.listDomainVerifications(ListDomainVerificationsPublisher.this.firstRequest);
            }
            return ListDomainVerificationsPublisher.this.client.listDomainVerifications((ListDomainVerificationsRequest)((Object)ListDomainVerificationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

