/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkVpcAssociationRequestSecurityGroupIdsListCopier;
import software.amazon.awssdk.services.vpclattice.model.DnsOptions;
import software.amazon.awssdk.services.vpclattice.model.TagMapCopier;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServiceNetworkVpcAssociationRequest
extends VpcLatticeRequest
implements ToCopyableBuilder<Builder, CreateServiceNetworkVpcAssociationRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateServiceNetworkVpcAssociationRequest.getter(CreateServiceNetworkVpcAssociationRequest::clientToken)).setter(CreateServiceNetworkVpcAssociationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> SERVICE_NETWORK_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkIdentifier").getter(CreateServiceNetworkVpcAssociationRequest.getter(CreateServiceNetworkVpcAssociationRequest::serviceNetworkIdentifier)).setter(CreateServiceNetworkVpcAssociationRequest.setter(Builder::serviceNetworkIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkIdentifier").build()}).build();
    private static final SdkField<String> VPC_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcIdentifier").getter(CreateServiceNetworkVpcAssociationRequest.getter(CreateServiceNetworkVpcAssociationRequest::vpcIdentifier)).setter(CreateServiceNetworkVpcAssociationRequest.setter(Builder::vpcIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcIdentifier").build()}).build();
    private static final SdkField<Boolean> PRIVATE_DNS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("privateDnsEnabled").getter(CreateServiceNetworkVpcAssociationRequest.getter(CreateServiceNetworkVpcAssociationRequest::privateDnsEnabled)).setter(CreateServiceNetworkVpcAssociationRequest.setter(Builder::privateDnsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateDnsEnabled").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIds").getter(CreateServiceNetworkVpcAssociationRequest.getter(CreateServiceNetworkVpcAssociationRequest::securityGroupIds)).setter(CreateServiceNetworkVpcAssociationRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateServiceNetworkVpcAssociationRequest.getter(CreateServiceNetworkVpcAssociationRequest::tags)).setter(CreateServiceNetworkVpcAssociationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<DnsOptions> DNS_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dnsOptions").getter(CreateServiceNetworkVpcAssociationRequest.getter(CreateServiceNetworkVpcAssociationRequest::dnsOptions)).setter(CreateServiceNetworkVpcAssociationRequest.setter(Builder::dnsOptions)).constructor(DnsOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, SERVICE_NETWORK_IDENTIFIER_FIELD, VPC_IDENTIFIER_FIELD, PRIVATE_DNS_ENABLED_FIELD, SECURITY_GROUP_IDS_FIELD, TAGS_FIELD, DNS_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateServiceNetworkVpcAssociationRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String serviceNetworkIdentifier;
    private final String vpcIdentifier;
    private final Boolean privateDnsEnabled;
    private final List<String> securityGroupIds;
    private final Map<String, String> tags;
    private final DnsOptions dnsOptions;

    private CreateServiceNetworkVpcAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.serviceNetworkIdentifier = builder.serviceNetworkIdentifier;
        this.vpcIdentifier = builder.vpcIdentifier;
        this.privateDnsEnabled = builder.privateDnsEnabled;
        this.securityGroupIds = builder.securityGroupIds;
        this.tags = builder.tags;
        this.dnsOptions = builder.dnsOptions;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String serviceNetworkIdentifier() {
        return this.serviceNetworkIdentifier;
    }

    public final String vpcIdentifier() {
        return this.vpcIdentifier;
    }

    public final Boolean privateDnsEnabled() {
        return this.privateDnsEnabled;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final DnsOptions dnsOptions() {
        return this.dnsOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceNetworkVpcAssociationRequest)) {
            return false;
        }
        CreateServiceNetworkVpcAssociationRequest other = (CreateServiceNetworkVpcAssociationRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.serviceNetworkIdentifier(), other.serviceNetworkIdentifier()) && Objects.equals(this.vpcIdentifier(), other.vpcIdentifier()) && Objects.equals(this.privateDnsEnabled(), other.privateDnsEnabled()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.dnsOptions(), other.dnsOptions());
    }

    public final String toString() {
        return ToString.builder((String)"CreateServiceNetworkVpcAssociationRequest").add("ClientToken", (Object)this.clientToken()).add("ServiceNetworkIdentifier", (Object)this.serviceNetworkIdentifier()).add("VpcIdentifier", (Object)this.vpcIdentifier()).add("PrivateDnsEnabled", (Object)this.privateDnsEnabled()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("Tags", this.hasTags() ? this.tags() : null).add("DnsOptions", (Object)this.dnsOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "serviceNetworkIdentifier": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkIdentifier()));
            }
            case "vpcIdentifier": {
                return Optional.ofNullable(clazz.cast(this.vpcIdentifier()));
            }
            case "privateDnsEnabled": {
                return Optional.ofNullable(clazz.cast(this.privateDnsEnabled()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "dnsOptions": {
                return Optional.ofNullable(clazz.cast(this.dnsOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("serviceNetworkIdentifier", SERVICE_NETWORK_IDENTIFIER_FIELD);
        map.put("vpcIdentifier", VPC_IDENTIFIER_FIELD);
        map.put("privateDnsEnabled", PRIVATE_DNS_ENABLED_FIELD);
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("dnsOptions", DNS_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceNetworkVpcAssociationRequest, T> g) {
        return obj -> g.apply((CreateServiceNetworkVpcAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String serviceNetworkIdentifier;
        private String vpcIdentifier;
        private Boolean privateDnsEnabled;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private DnsOptions dnsOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceNetworkVpcAssociationRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.serviceNetworkIdentifier(model.serviceNetworkIdentifier);
            this.vpcIdentifier(model.vpcIdentifier);
            this.privateDnsEnabled(model.privateDnsEnabled);
            this.securityGroupIds(model.securityGroupIds);
            this.tags(model.tags);
            this.dnsOptions(model.dnsOptions);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getServiceNetworkIdentifier() {
            return this.serviceNetworkIdentifier;
        }

        public final void setServiceNetworkIdentifier(String serviceNetworkIdentifier) {
            this.serviceNetworkIdentifier = serviceNetworkIdentifier;
        }

        @Override
        public final Builder serviceNetworkIdentifier(String serviceNetworkIdentifier) {
            this.serviceNetworkIdentifier = serviceNetworkIdentifier;
            return this;
        }

        public final String getVpcIdentifier() {
            return this.vpcIdentifier;
        }

        public final void setVpcIdentifier(String vpcIdentifier) {
            this.vpcIdentifier = vpcIdentifier;
        }

        @Override
        public final Builder vpcIdentifier(String vpcIdentifier) {
            this.vpcIdentifier = vpcIdentifier;
            return this;
        }

        public final Boolean getPrivateDnsEnabled() {
            return this.privateDnsEnabled;
        }

        public final void setPrivateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
        }

        @Override
        public final Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = CreateServiceNetworkVpcAssociationRequestSecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = CreateServiceNetworkVpcAssociationRequestSecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final DnsOptions.Builder getDnsOptions() {
            return this.dnsOptions != null ? this.dnsOptions.toBuilder() : null;
        }

        public final void setDnsOptions(DnsOptions.BuilderImpl dnsOptions) {
            this.dnsOptions = dnsOptions != null ? dnsOptions.build() : null;
        }

        @Override
        public final Builder dnsOptions(DnsOptions dnsOptions) {
            this.dnsOptions = dnsOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceNetworkVpcAssociationRequest build() {
            return new CreateServiceNetworkVpcAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VpcLatticeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateServiceNetworkVpcAssociationRequest> {
        public Builder clientToken(String var1);

        public Builder serviceNetworkIdentifier(String var1);

        public Builder vpcIdentifier(String var1);

        public Builder privateDnsEnabled(Boolean var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder dnsOptions(DnsOptions var1);

        default public Builder dnsOptions(Consumer<DnsOptions.Builder> dnsOptions) {
            return this.dnsOptions((DnsOptions)((DnsOptions.Builder)DnsOptions.builder().applyMutation(dnsOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

