/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.IntegratingService;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIntegrationRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, UpdateIntegrationRequest> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(UpdateIntegrationRequest.getter(UpdateIntegrationRequest::workloadId)).setter(UpdateIntegrationRequest.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("WorkloadId").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(UpdateIntegrationRequest.getter(UpdateIntegrationRequest::clientRequestToken)).setter(UpdateIntegrationRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> INTEGRATING_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegratingService").getter(UpdateIntegrationRequest.getter(UpdateIntegrationRequest::integratingServiceAsString)).setter(UpdateIntegrationRequest.setter(Builder::integratingService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegratingService").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, CLIENT_REQUEST_TOKEN_FIELD, INTEGRATING_SERVICE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateIntegrationRequest.memberNameToFieldInitializer();
    private final String workloadId;
    private final String clientRequestToken;
    private final String integratingService;

    private UpdateIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.clientRequestToken = builder.clientRequestToken;
        this.integratingService = builder.integratingService;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final IntegratingService integratingService() {
        return IntegratingService.fromValue(this.integratingService);
    }

    public final String integratingServiceAsString() {
        return this.integratingService;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.integratingServiceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIntegrationRequest)) {
            return false;
        }
        UpdateIntegrationRequest other = (UpdateIntegrationRequest)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.integratingServiceAsString(), other.integratingServiceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIntegrationRequest").add("WorkloadId", (Object)this.workloadId()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("IntegratingService", (Object)this.integratingServiceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "IntegratingService": {
                return Optional.ofNullable(clazz.cast(this.integratingServiceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("WorkloadId", WORKLOAD_ID_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("IntegratingService", INTEGRATING_SERVICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIntegrationRequest, T> g) {
        return obj -> g.apply((UpdateIntegrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String workloadId;
        private String clientRequestToken;
        private String integratingService;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIntegrationRequest model) {
            super(model);
            this.workloadId(model.workloadId);
            this.clientRequestToken(model.clientRequestToken);
            this.integratingService(model.integratingService);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getIntegratingService() {
            return this.integratingService;
        }

        public final void setIntegratingService(String integratingService) {
            this.integratingService = integratingService;
        }

        @Override
        public final Builder integratingService(String integratingService) {
            this.integratingService = integratingService;
            return this;
        }

        @Override
        public final Builder integratingService(IntegratingService integratingService) {
            this.integratingService(integratingService == null ? null : integratingService.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIntegrationRequest build() {
            return new UpdateIntegrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIntegrationRequest> {
        public Builder workloadId(String var1);

        public Builder clientRequestToken(String var1);

        public Builder integratingService(String var1);

        public Builder integratingService(IntegratingService var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

