/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wickr.model.AccessLevel;
import software.amazon.awssdk.services.wickr.model.WickrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetNetworkResponse
extends WickrResponse
implements ToCopyableBuilder<Builder, GetNetworkResponse> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkId").getter(GetNetworkResponse.getter(GetNetworkResponse::networkId)).setter(GetNetworkResponse.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkId").build()}).build();
    private static final SdkField<String> NETWORK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkName").getter(GetNetworkResponse.getter(GetNetworkResponse::networkName)).setter(GetNetworkResponse.setter(Builder::networkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkName").build()}).build();
    private static final SdkField<String> ACCESS_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessLevel").getter(GetNetworkResponse.getter(GetNetworkResponse::accessLevelAsString)).setter(GetNetworkResponse.setter(Builder::accessLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessLevel").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountId").getter(GetNetworkResponse.getter(GetNetworkResponse::awsAccountId)).setter(GetNetworkResponse.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()}).build();
    private static final SdkField<String> NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkArn").getter(GetNetworkResponse.getter(GetNetworkResponse::networkArn)).setter(GetNetworkResponse.setter(Builder::networkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkArn").build()}).build();
    private static final SdkField<Integer> STANDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("standing").getter(GetNetworkResponse.getter(GetNetworkResponse::standing)).setter(GetNetworkResponse.setter(Builder::standing)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standing").build()}).build();
    private static final SdkField<String> FREE_TRIAL_EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("freeTrialExpiration").getter(GetNetworkResponse.getter(GetNetworkResponse::freeTrialExpiration)).setter(GetNetworkResponse.setter(Builder::freeTrialExpiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("freeTrialExpiration").build()}).build();
    private static final SdkField<Integer> MIGRATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("migrationState").getter(GetNetworkResponse.getter(GetNetworkResponse::migrationState)).setter(GetNetworkResponse.setter(Builder::migrationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationState").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionKeyArn").getter(GetNetworkResponse.getter(GetNetworkResponse::encryptionKeyArn)).setter(GetNetworkResponse.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, NETWORK_NAME_FIELD, ACCESS_LEVEL_FIELD, AWS_ACCOUNT_ID_FIELD, NETWORK_ARN_FIELD, STANDING_FIELD, FREE_TRIAL_EXPIRATION_FIELD, MIGRATION_STATE_FIELD, ENCRYPTION_KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetNetworkResponse.memberNameToFieldInitializer();
    private final String networkId;
    private final String networkName;
    private final String accessLevel;
    private final String awsAccountId;
    private final String networkArn;
    private final Integer standing;
    private final String freeTrialExpiration;
    private final Integer migrationState;
    private final String encryptionKeyArn;

    private GetNetworkResponse(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.networkName = builder.networkName;
        this.accessLevel = builder.accessLevel;
        this.awsAccountId = builder.awsAccountId;
        this.networkArn = builder.networkArn;
        this.standing = builder.standing;
        this.freeTrialExpiration = builder.freeTrialExpiration;
        this.migrationState = builder.migrationState;
        this.encryptionKeyArn = builder.encryptionKeyArn;
    }

    public final String networkId() {
        return this.networkId;
    }

    public final String networkName() {
        return this.networkName;
    }

    public final AccessLevel accessLevel() {
        return AccessLevel.fromValue(this.accessLevel);
    }

    public final String accessLevelAsString() {
        return this.accessLevel;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String networkArn() {
        return this.networkArn;
    }

    public final Integer standing() {
        return this.standing;
    }

    public final String freeTrialExpiration() {
        return this.freeTrialExpiration;
    }

    public final Integer migrationState() {
        return this.migrationState;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.standing());
        hashCode = 31 * hashCode + Objects.hashCode(this.freeTrialExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationState());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNetworkResponse)) {
            return false;
        }
        GetNetworkResponse other = (GetNetworkResponse)((Object)obj);
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.networkName(), other.networkName()) && Objects.equals(this.accessLevelAsString(), other.accessLevelAsString()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.networkArn(), other.networkArn()) && Objects.equals(this.standing(), other.standing()) && Objects.equals(this.freeTrialExpiration(), other.freeTrialExpiration()) && Objects.equals(this.migrationState(), other.migrationState()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetNetworkResponse").add("NetworkId", (Object)this.networkId()).add("NetworkName", (Object)this.networkName()).add("AccessLevel", (Object)this.accessLevelAsString()).add("AwsAccountId", (Object)this.awsAccountId()).add("NetworkArn", (Object)this.networkArn()).add("Standing", (Object)this.standing()).add("FreeTrialExpiration", (Object)this.freeTrialExpiration()).add("MigrationState", (Object)this.migrationState()).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "networkName": {
                return Optional.ofNullable(clazz.cast(this.networkName()));
            }
            case "accessLevel": {
                return Optional.ofNullable(clazz.cast(this.accessLevelAsString()));
            }
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "networkArn": {
                return Optional.ofNullable(clazz.cast(this.networkArn()));
            }
            case "standing": {
                return Optional.ofNullable(clazz.cast(this.standing()));
            }
            case "freeTrialExpiration": {
                return Optional.ofNullable(clazz.cast(this.freeTrialExpiration()));
            }
            case "migrationState": {
                return Optional.ofNullable(clazz.cast(this.migrationState()));
            }
            case "encryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("networkId", NETWORK_ID_FIELD);
        map.put("networkName", NETWORK_NAME_FIELD);
        map.put("accessLevel", ACCESS_LEVEL_FIELD);
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("networkArn", NETWORK_ARN_FIELD);
        map.put("standing", STANDING_FIELD);
        map.put("freeTrialExpiration", FREE_TRIAL_EXPIRATION_FIELD);
        map.put("migrationState", MIGRATION_STATE_FIELD);
        map.put("encryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetNetworkResponse, T> g) {
        return obj -> g.apply((GetNetworkResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrResponse.BuilderImpl
    implements Builder {
        private String networkId;
        private String networkName;
        private String accessLevel;
        private String awsAccountId;
        private String networkArn;
        private Integer standing;
        private String freeTrialExpiration;
        private Integer migrationState;
        private String encryptionKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNetworkResponse model) {
            super(model);
            this.networkId(model.networkId);
            this.networkName(model.networkName);
            this.accessLevel(model.accessLevel);
            this.awsAccountId(model.awsAccountId);
            this.networkArn(model.networkArn);
            this.standing(model.standing);
            this.freeTrialExpiration(model.freeTrialExpiration);
            this.migrationState(model.migrationState);
            this.encryptionKeyArn(model.encryptionKeyArn);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final String getNetworkName() {
            return this.networkName;
        }

        public final void setNetworkName(String networkName) {
            this.networkName = networkName;
        }

        @Override
        public final Builder networkName(String networkName) {
            this.networkName = networkName;
            return this;
        }

        public final String getAccessLevel() {
            return this.accessLevel;
        }

        public final void setAccessLevel(String accessLevel) {
            this.accessLevel = accessLevel;
        }

        @Override
        public final Builder accessLevel(String accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        @Override
        public final Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel(accessLevel == null ? null : accessLevel.toString());
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getNetworkArn() {
            return this.networkArn;
        }

        public final void setNetworkArn(String networkArn) {
            this.networkArn = networkArn;
        }

        @Override
        public final Builder networkArn(String networkArn) {
            this.networkArn = networkArn;
            return this;
        }

        public final Integer getStanding() {
            return this.standing;
        }

        public final void setStanding(Integer standing) {
            this.standing = standing;
        }

        @Override
        public final Builder standing(Integer standing) {
            this.standing = standing;
            return this;
        }

        public final String getFreeTrialExpiration() {
            return this.freeTrialExpiration;
        }

        public final void setFreeTrialExpiration(String freeTrialExpiration) {
            this.freeTrialExpiration = freeTrialExpiration;
        }

        @Override
        public final Builder freeTrialExpiration(String freeTrialExpiration) {
            this.freeTrialExpiration = freeTrialExpiration;
            return this;
        }

        public final Integer getMigrationState() {
            return this.migrationState;
        }

        public final void setMigrationState(Integer migrationState) {
            this.migrationState = migrationState;
        }

        @Override
        public final Builder migrationState(Integer migrationState) {
            this.migrationState = migrationState;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        @Override
        public GetNetworkResponse build() {
            return new GetNetworkResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetNetworkResponse> {
        public Builder networkId(String var1);

        public Builder networkName(String var1);

        public Builder accessLevel(String var1);

        public Builder accessLevel(AccessLevel var1);

        public Builder awsAccountId(String var1);

        public Builder networkArn(String var1);

        public Builder standing(Integer var1);

        public Builder freeTrialExpiration(String var1);

        public Builder migrationState(Integer var1);

        public Builder encryptionKeyArn(String var1);
    }
}

