/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wickr.model.SortDirection;
import software.amazon.awssdk.services.wickr.model.WickrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDevicesForUserRequest
extends WickrRequest
implements ToCopyableBuilder<Builder, ListDevicesForUserRequest> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkId").getter(ListDevicesForUserRequest.getter(ListDevicesForUserRequest::networkId)).setter(ListDevicesForUserRequest.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(ListDevicesForUserRequest.getter(ListDevicesForUserRequest::userId)).setter(ListDevicesForUserRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("userId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDevicesForUserRequest.getter(ListDevicesForUserRequest::nextToken)).setter(ListDevicesForUserRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListDevicesForUserRequest.getter(ListDevicesForUserRequest::maxResults)).setter(ListDevicesForUserRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> SORT_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortFields").getter(ListDevicesForUserRequest.getter(ListDevicesForUserRequest::sortFields)).setter(ListDevicesForUserRequest.setter(Builder::sortFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortFields").build()}).build();
    private static final SdkField<String> SORT_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortDirection").getter(ListDevicesForUserRequest.getter(ListDevicesForUserRequest::sortDirectionAsString)).setter(ListDevicesForUserRequest.setter(Builder::sortDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortDirection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, USER_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SORT_FIELDS_FIELD, SORT_DIRECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDevicesForUserRequest.memberNameToFieldInitializer();
    private final String networkId;
    private final String userId;
    private final String nextToken;
    private final Integer maxResults;
    private final String sortFields;
    private final String sortDirection;

    private ListDevicesForUserRequest(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.userId = builder.userId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.sortFields = builder.sortFields;
        this.sortDirection = builder.sortDirection;
    }

    public final String networkId() {
        return this.networkId;
    }

    public final String userId() {
        return this.userId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String sortFields() {
        return this.sortFields;
    }

    public final SortDirection sortDirection() {
        return SortDirection.fromValue(this.sortDirection);
    }

    public final String sortDirectionAsString() {
        return this.sortDirection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortFields());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortDirectionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicesForUserRequest)) {
            return false;
        }
        ListDevicesForUserRequest other = (ListDevicesForUserRequest)((Object)obj);
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.sortFields(), other.sortFields()) && Objects.equals(this.sortDirectionAsString(), other.sortDirectionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListDevicesForUserRequest").add("NetworkId", (Object)this.networkId()).add("UserId", (Object)this.userId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("SortFields", (Object)this.sortFields()).add("SortDirection", (Object)this.sortDirectionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "sortFields": {
                return Optional.ofNullable(clazz.cast(this.sortFields()));
            }
            case "sortDirection": {
                return Optional.ofNullable(clazz.cast(this.sortDirectionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("networkId", NETWORK_ID_FIELD);
        map.put("userId", USER_ID_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("sortFields", SORT_FIELDS_FIELD);
        map.put("sortDirection", SORT_DIRECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDevicesForUserRequest, T> g) {
        return obj -> g.apply((ListDevicesForUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrRequest.BuilderImpl
    implements Builder {
        private String networkId;
        private String userId;
        private String nextToken;
        private Integer maxResults;
        private String sortFields;
        private String sortDirection;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicesForUserRequest model) {
            super(model);
            this.networkId(model.networkId);
            this.userId(model.userId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.sortFields(model.sortFields);
            this.sortDirection(model.sortDirection);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getSortFields() {
            return this.sortFields;
        }

        public final void setSortFields(String sortFields) {
            this.sortFields = sortFields;
        }

        @Override
        public final Builder sortFields(String sortFields) {
            this.sortFields = sortFields;
            return this;
        }

        public final String getSortDirection() {
            return this.sortDirection;
        }

        public final void setSortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
        }

        @Override
        public final Builder sortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        @Override
        public final Builder sortDirection(SortDirection sortDirection) {
            this.sortDirection(sortDirection == null ? null : sortDirection.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDevicesForUserRequest build() {
            return new ListDevicesForUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDevicesForUserRequest> {
        public Builder networkId(String var1);

        public Builder userId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder sortFields(String var1);

        public Builder sortDirection(String var1);

        public Builder sortDirection(SortDirection var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

