/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wickr.model.WickrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBotRequest
extends WickrRequest
implements ToCopyableBuilder<Builder, UpdateBotRequest> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkId").getter(UpdateBotRequest.getter(UpdateBotRequest::networkId)).setter(UpdateBotRequest.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()}).build();
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(UpdateBotRequest.getter(UpdateBotRequest::botId)).setter(UpdateBotRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateBotRequest.getter(UpdateBotRequest::displayName)).setter(UpdateBotRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupId").getter(UpdateBotRequest.getter(UpdateBotRequest::groupId)).setter(UpdateBotRequest.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupId").build()}).build();
    private static final SdkField<String> CHALLENGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("challenge").getter(UpdateBotRequest.getter(UpdateBotRequest::challenge)).setter(UpdateBotRequest.setter(Builder::challenge)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("challenge").build()}).build();
    private static final SdkField<Boolean> SUSPEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("suspend").getter(UpdateBotRequest.getter(UpdateBotRequest::suspend)).setter(UpdateBotRequest.setter(Builder::suspend)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suspend").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, BOT_ID_FIELD, DISPLAY_NAME_FIELD, GROUP_ID_FIELD, CHALLENGE_FIELD, SUSPEND_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateBotRequest.memberNameToFieldInitializer();
    private final String networkId;
    private final String botId;
    private final String displayName;
    private final String groupId;
    private final String challenge;
    private final Boolean suspend;

    private UpdateBotRequest(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.botId = builder.botId;
        this.displayName = builder.displayName;
        this.groupId = builder.groupId;
        this.challenge = builder.challenge;
        this.suspend = builder.suspend;
    }

    public final String networkId() {
        return this.networkId;
    }

    public final String botId() {
        return this.botId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final String challenge() {
        return this.challenge;
    }

    public final Boolean suspend() {
        return this.suspend;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.challenge());
        hashCode = 31 * hashCode + Objects.hashCode(this.suspend());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBotRequest)) {
            return false;
        }
        UpdateBotRequest other = (UpdateBotRequest)((Object)obj);
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.botId(), other.botId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.challenge(), other.challenge()) && Objects.equals(this.suspend(), other.suspend());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBotRequest").add("NetworkId", (Object)this.networkId()).add("BotId", (Object)this.botId()).add("DisplayName", (Object)this.displayName()).add("GroupId", (Object)this.groupId()).add("Challenge", (Object)(this.challenge() == null ? null : "*** Sensitive Data Redacted ***")).add("Suspend", (Object)this.suspend()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "groupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "challenge": {
                return Optional.ofNullable(clazz.cast(this.challenge()));
            }
            case "suspend": {
                return Optional.ofNullable(clazz.cast(this.suspend()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("networkId", NETWORK_ID_FIELD);
        map.put("botId", BOT_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("groupId", GROUP_ID_FIELD);
        map.put("challenge", CHALLENGE_FIELD);
        map.put("suspend", SUSPEND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBotRequest, T> g) {
        return obj -> g.apply((UpdateBotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrRequest.BuilderImpl
    implements Builder {
        private String networkId;
        private String botId;
        private String displayName;
        private String groupId;
        private String challenge;
        private Boolean suspend;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBotRequest model) {
            super(model);
            this.networkId(model.networkId);
            this.botId(model.botId);
            this.displayName(model.displayName);
            this.groupId(model.groupId);
            this.challenge(model.challenge);
            this.suspend(model.suspend);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getChallenge() {
            return this.challenge;
        }

        public final void setChallenge(String challenge) {
            this.challenge = challenge;
        }

        @Override
        public final Builder challenge(String challenge) {
            this.challenge = challenge;
            return this;
        }

        public final Boolean getSuspend() {
            return this.suspend;
        }

        public final void setSuspend(Boolean suspend) {
            this.suspend = suspend;
        }

        @Override
        public final Builder suspend(Boolean suspend) {
            this.suspend = suspend;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBotRequest build() {
            return new UpdateBotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBotRequest> {
        public Builder networkId(String var1);

        public Builder botId(String var1);

        public Builder displayName(String var1);

        public Builder groupId(String var1);

        public Builder challenge(String var1);

        public Builder suspend(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

