/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wickr.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateUserDetails> {
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("firstName").getter(UpdateUserDetails.getter(UpdateUserDetails::firstName)).setter(UpdateUserDetails.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastName").getter(UpdateUserDetails.getter(UpdateUserDetails::lastName)).setter(UpdateUserDetails.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastName").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("username").getter(UpdateUserDetails.getter(UpdateUserDetails::username)).setter(UpdateUserDetails.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIds").getter(UpdateUserDetails.getter(UpdateUserDetails::securityGroupIds)).setter(UpdateUserDetails.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INVITE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inviteCode").getter(UpdateUserDetails.getter(UpdateUserDetails::inviteCode)).setter(UpdateUserDetails.setter(Builder::inviteCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inviteCode").build()}).build();
    private static final SdkField<Integer> INVITE_CODE_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("inviteCodeTtl").getter(UpdateUserDetails.getter(UpdateUserDetails::inviteCodeTtl)).setter(UpdateUserDetails.setter(Builder::inviteCodeTtl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inviteCodeTtl").build()}).build();
    private static final SdkField<Boolean> CODE_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("codeValidation").getter(UpdateUserDetails.getter(UpdateUserDetails::codeValidation)).setter(UpdateUserDetails.setter(Builder::codeValidation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeValidation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIRST_NAME_FIELD, LAST_NAME_FIELD, USERNAME_FIELD, SECURITY_GROUP_IDS_FIELD, INVITE_CODE_FIELD, INVITE_CODE_TTL_FIELD, CODE_VALIDATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateUserDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String firstName;
    private final String lastName;
    private final String username;
    private final List<String> securityGroupIds;
    private final String inviteCode;
    private final Integer inviteCodeTtl;
    private final Boolean codeValidation;

    private UpdateUserDetails(BuilderImpl builder) {
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.username = builder.username;
        this.securityGroupIds = builder.securityGroupIds;
        this.inviteCode = builder.inviteCode;
        this.inviteCodeTtl = builder.inviteCodeTtl;
        this.codeValidation = builder.codeValidation;
    }

    public final String firstName() {
        return this.firstName;
    }

    public final String lastName() {
        return this.lastName;
    }

    public final String username() {
        return this.username;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final String inviteCode() {
        return this.inviteCode;
    }

    public final Integer inviteCodeTtl() {
        return this.inviteCodeTtl;
    }

    public final Boolean codeValidation() {
        return this.codeValidation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inviteCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.inviteCodeTtl());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeValidation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserDetails)) {
            return false;
        }
        UpdateUserDetails other = (UpdateUserDetails)obj;
        return Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.username(), other.username()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.inviteCode(), other.inviteCode()) && Objects.equals(this.inviteCodeTtl(), other.inviteCodeTtl()) && Objects.equals(this.codeValidation(), other.codeValidation());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUserDetails").add("FirstName", (Object)(this.firstName() == null ? null : "*** Sensitive Data Redacted ***")).add("LastName", (Object)(this.lastName() == null ? null : "*** Sensitive Data Redacted ***")).add("Username", (Object)this.username()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("InviteCode", (Object)this.inviteCode()).add("InviteCodeTtl", (Object)this.inviteCodeTtl()).add("CodeValidation", (Object)this.codeValidation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "firstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "lastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
            case "username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "inviteCode": {
                return Optional.ofNullable(clazz.cast(this.inviteCode()));
            }
            case "inviteCodeTtl": {
                return Optional.ofNullable(clazz.cast(this.inviteCodeTtl()));
            }
            case "codeValidation": {
                return Optional.ofNullable(clazz.cast(this.codeValidation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("firstName", FIRST_NAME_FIELD);
        map.put("lastName", LAST_NAME_FIELD);
        map.put("username", USERNAME_FIELD);
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("inviteCode", INVITE_CODE_FIELD);
        map.put("inviteCodeTtl", INVITE_CODE_TTL_FIELD);
        map.put("codeValidation", CODE_VALIDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserDetails, T> g) {
        return obj -> g.apply((UpdateUserDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String firstName;
        private String lastName;
        private String username;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String inviteCode;
        private Integer inviteCodeTtl;
        private Boolean codeValidation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserDetails model) {
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.username(model.username);
            this.securityGroupIds(model.securityGroupIds);
            this.inviteCode(model.inviteCode);
            this.inviteCodeTtl(model.inviteCodeTtl);
            this.codeValidation(model.codeValidation);
        }

        public final String getFirstName() {
            return this.firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return this.lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getInviteCode() {
            return this.inviteCode;
        }

        public final void setInviteCode(String inviteCode) {
            this.inviteCode = inviteCode;
        }

        @Override
        public final Builder inviteCode(String inviteCode) {
            this.inviteCode = inviteCode;
            return this;
        }

        public final Integer getInviteCodeTtl() {
            return this.inviteCodeTtl;
        }

        public final void setInviteCodeTtl(Integer inviteCodeTtl) {
            this.inviteCodeTtl = inviteCodeTtl;
        }

        @Override
        public final Builder inviteCodeTtl(Integer inviteCodeTtl) {
            this.inviteCodeTtl = inviteCodeTtl;
            return this;
        }

        public final Boolean getCodeValidation() {
            return this.codeValidation;
        }

        public final void setCodeValidation(Boolean codeValidation) {
            this.codeValidation = codeValidation;
        }

        @Override
        public final Builder codeValidation(Boolean codeValidation) {
            this.codeValidation = codeValidation;
            return this;
        }

        public UpdateUserDetails build() {
            return new UpdateUserDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateUserDetails> {
        public Builder firstName(String var1);

        public Builder lastName(String var1);

        public Builder username(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder inviteCode(String var1);

        public Builder inviteCodeTtl(Integer var1);

        public Builder codeValidation(Boolean var1);
    }
}

