/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wickr.model.ReadReceiptConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkSettings> {
    private static final SdkField<Boolean> ENABLE_CLIENT_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableClientMetrics").getter(NetworkSettings.getter(NetworkSettings::enableClientMetrics)).setter(NetworkSettings.setter(Builder::enableClientMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableClientMetrics").build()}).build();
    private static final SdkField<ReadReceiptConfig> READ_RECEIPT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("readReceiptConfig").getter(NetworkSettings.getter(NetworkSettings::readReceiptConfig)).setter(NetworkSettings.setter(Builder::readReceiptConfig)).constructor(ReadReceiptConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readReceiptConfig").build()}).build();
    private static final SdkField<Boolean> DATA_RETENTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("dataRetention").getter(NetworkSettings.getter(NetworkSettings::dataRetention)).setter(NetworkSettings.setter(Builder::dataRetention)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataRetention").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_CLIENT_METRICS_FIELD, READ_RECEIPT_CONFIG_FIELD, DATA_RETENTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enableClientMetrics;
    private final ReadReceiptConfig readReceiptConfig;
    private final Boolean dataRetention;

    private NetworkSettings(BuilderImpl builder) {
        this.enableClientMetrics = builder.enableClientMetrics;
        this.readReceiptConfig = builder.readReceiptConfig;
        this.dataRetention = builder.dataRetention;
    }

    public final Boolean enableClientMetrics() {
        return this.enableClientMetrics;
    }

    public final ReadReceiptConfig readReceiptConfig() {
        return this.readReceiptConfig;
    }

    public final Boolean dataRetention() {
        return this.dataRetention;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enableClientMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.readReceiptConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRetention());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkSettings)) {
            return false;
        }
        NetworkSettings other = (NetworkSettings)obj;
        return Objects.equals(this.enableClientMetrics(), other.enableClientMetrics()) && Objects.equals(this.readReceiptConfig(), other.readReceiptConfig()) && Objects.equals(this.dataRetention(), other.dataRetention());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkSettings").add("EnableClientMetrics", (Object)this.enableClientMetrics()).add("ReadReceiptConfig", (Object)this.readReceiptConfig()).add("DataRetention", (Object)this.dataRetention()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enableClientMetrics": {
                return Optional.ofNullable(clazz.cast(this.enableClientMetrics()));
            }
            case "readReceiptConfig": {
                return Optional.ofNullable(clazz.cast(this.readReceiptConfig()));
            }
            case "dataRetention": {
                return Optional.ofNullable(clazz.cast(this.dataRetention()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enableClientMetrics", ENABLE_CLIENT_METRICS_FIELD);
        map.put("readReceiptConfig", READ_RECEIPT_CONFIG_FIELD);
        map.put("dataRetention", DATA_RETENTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkSettings, T> g) {
        return obj -> g.apply((NetworkSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enableClientMetrics;
        private ReadReceiptConfig readReceiptConfig;
        private Boolean dataRetention;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkSettings model) {
            this.enableClientMetrics(model.enableClientMetrics);
            this.readReceiptConfig(model.readReceiptConfig);
            this.dataRetention(model.dataRetention);
        }

        public final Boolean getEnableClientMetrics() {
            return this.enableClientMetrics;
        }

        public final void setEnableClientMetrics(Boolean enableClientMetrics) {
            this.enableClientMetrics = enableClientMetrics;
        }

        @Override
        public final Builder enableClientMetrics(Boolean enableClientMetrics) {
            this.enableClientMetrics = enableClientMetrics;
            return this;
        }

        public final ReadReceiptConfig.Builder getReadReceiptConfig() {
            return this.readReceiptConfig != null ? this.readReceiptConfig.toBuilder() : null;
        }

        public final void setReadReceiptConfig(ReadReceiptConfig.BuilderImpl readReceiptConfig) {
            this.readReceiptConfig = readReceiptConfig != null ? readReceiptConfig.build() : null;
        }

        @Override
        public final Builder readReceiptConfig(ReadReceiptConfig readReceiptConfig) {
            this.readReceiptConfig = readReceiptConfig;
            return this;
        }

        public final Boolean getDataRetention() {
            return this.dataRetention;
        }

        public final void setDataRetention(Boolean dataRetention) {
            this.dataRetention = dataRetention;
        }

        @Override
        public final Builder dataRetention(Boolean dataRetention) {
            this.dataRetention = dataRetention;
            return this;
        }

        public NetworkSettings build() {
            return new NetworkSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkSettings> {
        public Builder enableClientMetrics(Boolean var1);

        public Builder readReceiptConfig(ReadReceiptConfig var1);

        default public Builder readReceiptConfig(Consumer<ReadReceiptConfig.Builder> readReceiptConfig) {
            return this.readReceiptConfig((ReadReceiptConfig)((ReadReceiptConfig.Builder)ReadReceiptConfig.builder().applyMutation(readReceiptConfig)).build());
        }

        public Builder dataRetention(Boolean var1);
    }
}

