/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wickr.model.PermittedNetworksListCopier;
import software.amazon.awssdk.services.wickr.model.PermittedWickrEnterpriseNetwork;
import software.amazon.awssdk.services.wickr.model.PermittedWickrEnterpriseNetworksListCopier;
import software.amazon.awssdk.services.wickr.model.WickrAwsNetworks;
import software.amazon.awssdk.services.wickr.model.WickrAwsNetworksListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityGroupSettingsRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityGroupSettingsRequest> {
    private static final SdkField<Integer> LOCKOUT_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("lockoutThreshold").getter(SecurityGroupSettingsRequest.getter(SecurityGroupSettingsRequest::lockoutThreshold)).setter(SecurityGroupSettingsRequest.setter(Builder::lockoutThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lockoutThreshold").build()}).build();
    private static final SdkField<List<String>> PERMITTED_NETWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("permittedNetworks").getter(SecurityGroupSettingsRequest.getter(SecurityGroupSettingsRequest::permittedNetworks)).setter(SecurityGroupSettingsRequest.setter(Builder::permittedNetworks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permittedNetworks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_GUEST_FEDERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableGuestFederation").getter(SecurityGroupSettingsRequest.getter(SecurityGroupSettingsRequest::enableGuestFederation)).setter(SecurityGroupSettingsRequest.setter(Builder::enableGuestFederation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableGuestFederation").build()}).build();
    private static final SdkField<Boolean> GLOBAL_FEDERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("globalFederation").getter(SecurityGroupSettingsRequest.getter(SecurityGroupSettingsRequest::globalFederation)).setter(SecurityGroupSettingsRequest.setter(Builder::globalFederation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalFederation").build()}).build();
    private static final SdkField<Integer> FEDERATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("federationMode").getter(SecurityGroupSettingsRequest.getter(SecurityGroupSettingsRequest::federationMode)).setter(SecurityGroupSettingsRequest.setter(Builder::federationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federationMode").build()}).build();
    private static final SdkField<Boolean> ENABLE_RESTRICTED_GLOBAL_FEDERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableRestrictedGlobalFederation").getter(SecurityGroupSettingsRequest.getter(SecurityGroupSettingsRequest::enableRestrictedGlobalFederation)).setter(SecurityGroupSettingsRequest.setter(Builder::enableRestrictedGlobalFederation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableRestrictedGlobalFederation").build()}).build();
    private static final SdkField<List<WickrAwsNetworks>> PERMITTED_WICKR_AWS_NETWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("permittedWickrAwsNetworks").getter(SecurityGroupSettingsRequest.getter(SecurityGroupSettingsRequest::permittedWickrAwsNetworks)).setter(SecurityGroupSettingsRequest.setter(Builder::permittedWickrAwsNetworks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permittedWickrAwsNetworks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WickrAwsNetworks::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PermittedWickrEnterpriseNetwork>> PERMITTED_WICKR_ENTERPRISE_NETWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("permittedWickrEnterpriseNetworks").getter(SecurityGroupSettingsRequest.getter(SecurityGroupSettingsRequest::permittedWickrEnterpriseNetworks)).setter(SecurityGroupSettingsRequest.setter(Builder::permittedWickrEnterpriseNetworks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permittedWickrEnterpriseNetworks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PermittedWickrEnterpriseNetwork::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCKOUT_THRESHOLD_FIELD, PERMITTED_NETWORKS_FIELD, ENABLE_GUEST_FEDERATION_FIELD, GLOBAL_FEDERATION_FIELD, FEDERATION_MODE_FIELD, ENABLE_RESTRICTED_GLOBAL_FEDERATION_FIELD, PERMITTED_WICKR_AWS_NETWORKS_FIELD, PERMITTED_WICKR_ENTERPRISE_NETWORKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SecurityGroupSettingsRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer lockoutThreshold;
    private final List<String> permittedNetworks;
    private final Boolean enableGuestFederation;
    private final Boolean globalFederation;
    private final Integer federationMode;
    private final Boolean enableRestrictedGlobalFederation;
    private final List<WickrAwsNetworks> permittedWickrAwsNetworks;
    private final List<PermittedWickrEnterpriseNetwork> permittedWickrEnterpriseNetworks;

    private SecurityGroupSettingsRequest(BuilderImpl builder) {
        this.lockoutThreshold = builder.lockoutThreshold;
        this.permittedNetworks = builder.permittedNetworks;
        this.enableGuestFederation = builder.enableGuestFederation;
        this.globalFederation = builder.globalFederation;
        this.federationMode = builder.federationMode;
        this.enableRestrictedGlobalFederation = builder.enableRestrictedGlobalFederation;
        this.permittedWickrAwsNetworks = builder.permittedWickrAwsNetworks;
        this.permittedWickrEnterpriseNetworks = builder.permittedWickrEnterpriseNetworks;
    }

    public final Integer lockoutThreshold() {
        return this.lockoutThreshold;
    }

    public final boolean hasPermittedNetworks() {
        return this.permittedNetworks != null && !(this.permittedNetworks instanceof SdkAutoConstructList);
    }

    public final List<String> permittedNetworks() {
        return this.permittedNetworks;
    }

    public final Boolean enableGuestFederation() {
        return this.enableGuestFederation;
    }

    public final Boolean globalFederation() {
        return this.globalFederation;
    }

    public final Integer federationMode() {
        return this.federationMode;
    }

    public final Boolean enableRestrictedGlobalFederation() {
        return this.enableRestrictedGlobalFederation;
    }

    public final boolean hasPermittedWickrAwsNetworks() {
        return this.permittedWickrAwsNetworks != null && !(this.permittedWickrAwsNetworks instanceof SdkAutoConstructList);
    }

    public final List<WickrAwsNetworks> permittedWickrAwsNetworks() {
        return this.permittedWickrAwsNetworks;
    }

    public final boolean hasPermittedWickrEnterpriseNetworks() {
        return this.permittedWickrEnterpriseNetworks != null && !(this.permittedWickrEnterpriseNetworks instanceof SdkAutoConstructList);
    }

    public final List<PermittedWickrEnterpriseNetwork> permittedWickrEnterpriseNetworks() {
        return this.permittedWickrEnterpriseNetworks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lockoutThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermittedNetworks() ? this.permittedNetworks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableGuestFederation());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalFederation());
        hashCode = 31 * hashCode + Objects.hashCode(this.federationMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableRestrictedGlobalFederation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermittedWickrAwsNetworks() ? this.permittedWickrAwsNetworks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermittedWickrEnterpriseNetworks() ? this.permittedWickrEnterpriseNetworks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupSettingsRequest)) {
            return false;
        }
        SecurityGroupSettingsRequest other = (SecurityGroupSettingsRequest)obj;
        return Objects.equals(this.lockoutThreshold(), other.lockoutThreshold()) && this.hasPermittedNetworks() == other.hasPermittedNetworks() && Objects.equals(this.permittedNetworks(), other.permittedNetworks()) && Objects.equals(this.enableGuestFederation(), other.enableGuestFederation()) && Objects.equals(this.globalFederation(), other.globalFederation()) && Objects.equals(this.federationMode(), other.federationMode()) && Objects.equals(this.enableRestrictedGlobalFederation(), other.enableRestrictedGlobalFederation()) && this.hasPermittedWickrAwsNetworks() == other.hasPermittedWickrAwsNetworks() && Objects.equals(this.permittedWickrAwsNetworks(), other.permittedWickrAwsNetworks()) && this.hasPermittedWickrEnterpriseNetworks() == other.hasPermittedWickrEnterpriseNetworks() && Objects.equals(this.permittedWickrEnterpriseNetworks(), other.permittedWickrEnterpriseNetworks());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityGroupSettingsRequest").add("LockoutThreshold", (Object)this.lockoutThreshold()).add("PermittedNetworks", this.hasPermittedNetworks() ? this.permittedNetworks() : null).add("EnableGuestFederation", (Object)this.enableGuestFederation()).add("GlobalFederation", (Object)this.globalFederation()).add("FederationMode", (Object)this.federationMode()).add("EnableRestrictedGlobalFederation", (Object)this.enableRestrictedGlobalFederation()).add("PermittedWickrAwsNetworks", this.hasPermittedWickrAwsNetworks() ? this.permittedWickrAwsNetworks() : null).add("PermittedWickrEnterpriseNetworks", this.hasPermittedWickrEnterpriseNetworks() ? this.permittedWickrEnterpriseNetworks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lockoutThreshold": {
                return Optional.ofNullable(clazz.cast(this.lockoutThreshold()));
            }
            case "permittedNetworks": {
                return Optional.ofNullable(clazz.cast(this.permittedNetworks()));
            }
            case "enableGuestFederation": {
                return Optional.ofNullable(clazz.cast(this.enableGuestFederation()));
            }
            case "globalFederation": {
                return Optional.ofNullable(clazz.cast(this.globalFederation()));
            }
            case "federationMode": {
                return Optional.ofNullable(clazz.cast(this.federationMode()));
            }
            case "enableRestrictedGlobalFederation": {
                return Optional.ofNullable(clazz.cast(this.enableRestrictedGlobalFederation()));
            }
            case "permittedWickrAwsNetworks": {
                return Optional.ofNullable(clazz.cast(this.permittedWickrAwsNetworks()));
            }
            case "permittedWickrEnterpriseNetworks": {
                return Optional.ofNullable(clazz.cast(this.permittedWickrEnterpriseNetworks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lockoutThreshold", LOCKOUT_THRESHOLD_FIELD);
        map.put("permittedNetworks", PERMITTED_NETWORKS_FIELD);
        map.put("enableGuestFederation", ENABLE_GUEST_FEDERATION_FIELD);
        map.put("globalFederation", GLOBAL_FEDERATION_FIELD);
        map.put("federationMode", FEDERATION_MODE_FIELD);
        map.put("enableRestrictedGlobalFederation", ENABLE_RESTRICTED_GLOBAL_FEDERATION_FIELD);
        map.put("permittedWickrAwsNetworks", PERMITTED_WICKR_AWS_NETWORKS_FIELD);
        map.put("permittedWickrEnterpriseNetworks", PERMITTED_WICKR_ENTERPRISE_NETWORKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroupSettingsRequest, T> g) {
        return obj -> g.apply((SecurityGroupSettingsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer lockoutThreshold;
        private List<String> permittedNetworks = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableGuestFederation;
        private Boolean globalFederation;
        private Integer federationMode;
        private Boolean enableRestrictedGlobalFederation;
        private List<WickrAwsNetworks> permittedWickrAwsNetworks = DefaultSdkAutoConstructList.getInstance();
        private List<PermittedWickrEnterpriseNetwork> permittedWickrEnterpriseNetworks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupSettingsRequest model) {
            this.lockoutThreshold(model.lockoutThreshold);
            this.permittedNetworks(model.permittedNetworks);
            this.enableGuestFederation(model.enableGuestFederation);
            this.globalFederation(model.globalFederation);
            this.federationMode(model.federationMode);
            this.enableRestrictedGlobalFederation(model.enableRestrictedGlobalFederation);
            this.permittedWickrAwsNetworks(model.permittedWickrAwsNetworks);
            this.permittedWickrEnterpriseNetworks(model.permittedWickrEnterpriseNetworks);
        }

        public final Integer getLockoutThreshold() {
            return this.lockoutThreshold;
        }

        public final void setLockoutThreshold(Integer lockoutThreshold) {
            this.lockoutThreshold = lockoutThreshold;
        }

        @Override
        public final Builder lockoutThreshold(Integer lockoutThreshold) {
            this.lockoutThreshold = lockoutThreshold;
            return this;
        }

        public final Collection<String> getPermittedNetworks() {
            if (this.permittedNetworks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permittedNetworks;
        }

        public final void setPermittedNetworks(Collection<String> permittedNetworks) {
            this.permittedNetworks = PermittedNetworksListCopier.copy(permittedNetworks);
        }

        @Override
        public final Builder permittedNetworks(Collection<String> permittedNetworks) {
            this.permittedNetworks = PermittedNetworksListCopier.copy(permittedNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permittedNetworks(String ... permittedNetworks) {
            this.permittedNetworks(Arrays.asList(permittedNetworks));
            return this;
        }

        public final Boolean getEnableGuestFederation() {
            return this.enableGuestFederation;
        }

        public final void setEnableGuestFederation(Boolean enableGuestFederation) {
            this.enableGuestFederation = enableGuestFederation;
        }

        @Override
        public final Builder enableGuestFederation(Boolean enableGuestFederation) {
            this.enableGuestFederation = enableGuestFederation;
            return this;
        }

        public final Boolean getGlobalFederation() {
            return this.globalFederation;
        }

        public final void setGlobalFederation(Boolean globalFederation) {
            this.globalFederation = globalFederation;
        }

        @Override
        public final Builder globalFederation(Boolean globalFederation) {
            this.globalFederation = globalFederation;
            return this;
        }

        public final Integer getFederationMode() {
            return this.federationMode;
        }

        public final void setFederationMode(Integer federationMode) {
            this.federationMode = federationMode;
        }

        @Override
        public final Builder federationMode(Integer federationMode) {
            this.federationMode = federationMode;
            return this;
        }

        public final Boolean getEnableRestrictedGlobalFederation() {
            return this.enableRestrictedGlobalFederation;
        }

        public final void setEnableRestrictedGlobalFederation(Boolean enableRestrictedGlobalFederation) {
            this.enableRestrictedGlobalFederation = enableRestrictedGlobalFederation;
        }

        @Override
        public final Builder enableRestrictedGlobalFederation(Boolean enableRestrictedGlobalFederation) {
            this.enableRestrictedGlobalFederation = enableRestrictedGlobalFederation;
            return this;
        }

        public final List<WickrAwsNetworks.Builder> getPermittedWickrAwsNetworks() {
            List<WickrAwsNetworks.Builder> result = WickrAwsNetworksListCopier.copyToBuilder(this.permittedWickrAwsNetworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermittedWickrAwsNetworks(Collection<WickrAwsNetworks.BuilderImpl> permittedWickrAwsNetworks) {
            this.permittedWickrAwsNetworks = WickrAwsNetworksListCopier.copyFromBuilder(permittedWickrAwsNetworks);
        }

        @Override
        public final Builder permittedWickrAwsNetworks(Collection<WickrAwsNetworks> permittedWickrAwsNetworks) {
            this.permittedWickrAwsNetworks = WickrAwsNetworksListCopier.copy(permittedWickrAwsNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permittedWickrAwsNetworks(WickrAwsNetworks ... permittedWickrAwsNetworks) {
            this.permittedWickrAwsNetworks(Arrays.asList(permittedWickrAwsNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permittedWickrAwsNetworks(Consumer<WickrAwsNetworks.Builder> ... permittedWickrAwsNetworks) {
            this.permittedWickrAwsNetworks(Stream.of(permittedWickrAwsNetworks).map(c -> (WickrAwsNetworks)((WickrAwsNetworks.Builder)WickrAwsNetworks.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PermittedWickrEnterpriseNetwork.Builder> getPermittedWickrEnterpriseNetworks() {
            List<PermittedWickrEnterpriseNetwork.Builder> result = PermittedWickrEnterpriseNetworksListCopier.copyToBuilder(this.permittedWickrEnterpriseNetworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermittedWickrEnterpriseNetworks(Collection<PermittedWickrEnterpriseNetwork.BuilderImpl> permittedWickrEnterpriseNetworks) {
            this.permittedWickrEnterpriseNetworks = PermittedWickrEnterpriseNetworksListCopier.copyFromBuilder(permittedWickrEnterpriseNetworks);
        }

        @Override
        public final Builder permittedWickrEnterpriseNetworks(Collection<PermittedWickrEnterpriseNetwork> permittedWickrEnterpriseNetworks) {
            this.permittedWickrEnterpriseNetworks = PermittedWickrEnterpriseNetworksListCopier.copy(permittedWickrEnterpriseNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permittedWickrEnterpriseNetworks(PermittedWickrEnterpriseNetwork ... permittedWickrEnterpriseNetworks) {
            this.permittedWickrEnterpriseNetworks(Arrays.asList(permittedWickrEnterpriseNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permittedWickrEnterpriseNetworks(Consumer<PermittedWickrEnterpriseNetwork.Builder> ... permittedWickrEnterpriseNetworks) {
            this.permittedWickrEnterpriseNetworks(Stream.of(permittedWickrEnterpriseNetworks).map(c -> (PermittedWickrEnterpriseNetwork)((PermittedWickrEnterpriseNetwork.Builder)PermittedWickrEnterpriseNetwork.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SecurityGroupSettingsRequest build() {
            return new SecurityGroupSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityGroupSettingsRequest> {
        public Builder lockoutThreshold(Integer var1);

        public Builder permittedNetworks(Collection<String> var1);

        public Builder permittedNetworks(String ... var1);

        public Builder enableGuestFederation(Boolean var1);

        public Builder globalFederation(Boolean var1);

        public Builder federationMode(Integer var1);

        public Builder enableRestrictedGlobalFederation(Boolean var1);

        public Builder permittedWickrAwsNetworks(Collection<WickrAwsNetworks> var1);

        public Builder permittedWickrAwsNetworks(WickrAwsNetworks ... var1);

        public Builder permittedWickrAwsNetworks(Consumer<WickrAwsNetworks.Builder> ... var1);

        public Builder permittedWickrEnterpriseNetworks(Collection<PermittedWickrEnterpriseNetwork> var1);

        public Builder permittedWickrEnterpriseNetworks(PermittedWickrEnterpriseNetwork ... var1);

        public Builder permittedWickrEnterpriseNetworks(Consumer<PermittedWickrEnterpriseNetwork.Builder> ... var1);
    }
}

