/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wickr.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.services.wickr.model.WickrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserResponse
extends WickrResponse
implements ToCopyableBuilder<Builder, UpdateUserResponse> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(UpdateUserResponse.getter(UpdateUserResponse::userId)).setter(UpdateUserResponse.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkId").getter(UpdateUserResponse.getter(UpdateUserResponse::networkId)).setter(UpdateUserResponse.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkId").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIds").getter(UpdateUserResponse.getter(UpdateUserResponse::securityGroupIds)).setter(UpdateUserResponse.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("firstName").getter(UpdateUserResponse.getter(UpdateUserResponse::firstName)).setter(UpdateUserResponse.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastName").getter(UpdateUserResponse.getter(UpdateUserResponse::lastName)).setter(UpdateUserResponse.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastName").build()}).build();
    private static final SdkField<String> MIDDLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("middleName").getter(UpdateUserResponse.getter(UpdateUserResponse::middleName)).setter(UpdateUserResponse.setter(Builder::middleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("middleName").build()}).build();
    private static final SdkField<Boolean> SUSPENDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("suspended").getter(UpdateUserResponse.getter(UpdateUserResponse::suspended)).setter(UpdateUserResponse.setter(Builder::suspended)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suspended").build()}).build();
    private static final SdkField<Integer> MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("modified").getter(UpdateUserResponse.getter(UpdateUserResponse::modified)).setter(UpdateUserResponse.setter(Builder::modified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modified").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("status").getter(UpdateUserResponse.getter(UpdateUserResponse::status)).setter(UpdateUserResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> INVITE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inviteCode").getter(UpdateUserResponse.getter(UpdateUserResponse::inviteCode)).setter(UpdateUserResponse.setter(Builder::inviteCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inviteCode").build()}).build();
    private static final SdkField<Integer> INVITE_EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("inviteExpiration").getter(UpdateUserResponse.getter(UpdateUserResponse::inviteExpiration)).setter(UpdateUserResponse.setter(Builder::inviteExpiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inviteExpiration").build()}).build();
    private static final SdkField<Boolean> CODE_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("codeValidation").getter(UpdateUserResponse.getter(UpdateUserResponse::codeValidation)).setter(UpdateUserResponse.setter(Builder::codeValidation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeValidation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, NETWORK_ID_FIELD, SECURITY_GROUP_IDS_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, MIDDLE_NAME_FIELD, SUSPENDED_FIELD, MODIFIED_FIELD, STATUS_FIELD, INVITE_CODE_FIELD, INVITE_EXPIRATION_FIELD, CODE_VALIDATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateUserResponse.memberNameToFieldInitializer();
    private final String userId;
    private final String networkId;
    private final List<String> securityGroupIds;
    private final String firstName;
    private final String lastName;
    private final String middleName;
    private final Boolean suspended;
    private final Integer modified;
    private final Integer status;
    private final String inviteCode;
    private final Integer inviteExpiration;
    private final Boolean codeValidation;

    private UpdateUserResponse(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.networkId = builder.networkId;
        this.securityGroupIds = builder.securityGroupIds;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.middleName = builder.middleName;
        this.suspended = builder.suspended;
        this.modified = builder.modified;
        this.status = builder.status;
        this.inviteCode = builder.inviteCode;
        this.inviteExpiration = builder.inviteExpiration;
        this.codeValidation = builder.codeValidation;
    }

    public final String userId() {
        return this.userId;
    }

    public final String networkId() {
        return this.networkId;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final String firstName() {
        return this.firstName;
    }

    public final String lastName() {
        return this.lastName;
    }

    public final String middleName() {
        return this.middleName;
    }

    public final Boolean suspended() {
        return this.suspended;
    }

    public final Integer modified() {
        return this.modified;
    }

    public final Integer status() {
        return this.status;
    }

    public final String inviteCode() {
        return this.inviteCode;
    }

    public final Integer inviteExpiration() {
        return this.inviteExpiration;
    }

    public final Boolean codeValidation() {
        return this.codeValidation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.middleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.suspended());
        hashCode = 31 * hashCode + Objects.hashCode(this.modified());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.inviteCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.inviteExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeValidation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserResponse)) {
            return false;
        }
        UpdateUserResponse other = (UpdateUserResponse)((Object)obj);
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.networkId(), other.networkId()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.middleName(), other.middleName()) && Objects.equals(this.suspended(), other.suspended()) && Objects.equals(this.modified(), other.modified()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.inviteCode(), other.inviteCode()) && Objects.equals(this.inviteExpiration(), other.inviteExpiration()) && Objects.equals(this.codeValidation(), other.codeValidation());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUserResponse").add("UserId", (Object)this.userId()).add("NetworkId", (Object)this.networkId()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("FirstName", (Object)(this.firstName() == null ? null : "*** Sensitive Data Redacted ***")).add("LastName", (Object)(this.lastName() == null ? null : "*** Sensitive Data Redacted ***")).add("MiddleName", (Object)this.middleName()).add("Suspended", (Object)this.suspended()).add("Modified", (Object)this.modified()).add("Status", (Object)this.status()).add("InviteCode", (Object)this.inviteCode()).add("InviteExpiration", (Object)this.inviteExpiration()).add("CodeValidation", (Object)this.codeValidation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "networkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "firstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "lastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
            case "middleName": {
                return Optional.ofNullable(clazz.cast(this.middleName()));
            }
            case "suspended": {
                return Optional.ofNullable(clazz.cast(this.suspended()));
            }
            case "modified": {
                return Optional.ofNullable(clazz.cast(this.modified()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "inviteCode": {
                return Optional.ofNullable(clazz.cast(this.inviteCode()));
            }
            case "inviteExpiration": {
                return Optional.ofNullable(clazz.cast(this.inviteExpiration()));
            }
            case "codeValidation": {
                return Optional.ofNullable(clazz.cast(this.codeValidation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", USER_ID_FIELD);
        map.put("networkId", NETWORK_ID_FIELD);
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("firstName", FIRST_NAME_FIELD);
        map.put("lastName", LAST_NAME_FIELD);
        map.put("middleName", MIDDLE_NAME_FIELD);
        map.put("suspended", SUSPENDED_FIELD);
        map.put("modified", MODIFIED_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("inviteCode", INVITE_CODE_FIELD);
        map.put("inviteExpiration", INVITE_EXPIRATION_FIELD);
        map.put("codeValidation", CODE_VALIDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserResponse, T> g) {
        return obj -> g.apply((UpdateUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrResponse.BuilderImpl
    implements Builder {
        private String userId;
        private String networkId;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String firstName;
        private String lastName;
        private String middleName;
        private Boolean suspended;
        private Integer modified;
        private Integer status;
        private String inviteCode;
        private Integer inviteExpiration;
        private Boolean codeValidation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserResponse model) {
            super(model);
            this.userId(model.userId);
            this.networkId(model.networkId);
            this.securityGroupIds(model.securityGroupIds);
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.middleName(model.middleName);
            this.suspended(model.suspended);
            this.modified(model.modified);
            this.status(model.status);
            this.inviteCode(model.inviteCode);
            this.inviteExpiration(model.inviteExpiration);
            this.codeValidation(model.codeValidation);
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getFirstName() {
            return this.firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return this.lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getMiddleName() {
            return this.middleName;
        }

        public final void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        @Override
        public final Builder middleName(String middleName) {
            this.middleName = middleName;
            return this;
        }

        public final Boolean getSuspended() {
            return this.suspended;
        }

        public final void setSuspended(Boolean suspended) {
            this.suspended = suspended;
        }

        @Override
        public final Builder suspended(Boolean suspended) {
            this.suspended = suspended;
            return this;
        }

        public final Integer getModified() {
            return this.modified;
        }

        public final void setModified(Integer modified) {
            this.modified = modified;
        }

        @Override
        public final Builder modified(Integer modified) {
            this.modified = modified;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getInviteCode() {
            return this.inviteCode;
        }

        public final void setInviteCode(String inviteCode) {
            this.inviteCode = inviteCode;
        }

        @Override
        public final Builder inviteCode(String inviteCode) {
            this.inviteCode = inviteCode;
            return this;
        }

        public final Integer getInviteExpiration() {
            return this.inviteExpiration;
        }

        public final void setInviteExpiration(Integer inviteExpiration) {
            this.inviteExpiration = inviteExpiration;
        }

        @Override
        public final Builder inviteExpiration(Integer inviteExpiration) {
            this.inviteExpiration = inviteExpiration;
            return this;
        }

        public final Boolean getCodeValidation() {
            return this.codeValidation;
        }

        public final void setCodeValidation(Boolean codeValidation) {
            this.codeValidation = codeValidation;
        }

        @Override
        public final Builder codeValidation(Boolean codeValidation) {
            this.codeValidation = codeValidation;
            return this;
        }

        @Override
        public UpdateUserResponse build() {
            return new UpdateUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserResponse> {
        public Builder userId(String var1);

        public Builder networkId(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder firstName(String var1);

        public Builder lastName(String var1);

        public Builder middleName(String var1);

        public Builder suspended(Boolean var1);

        public Builder modified(Integer var1);

        public Builder status(Integer var1);

        public Builder inviteCode(String var1);

        public Builder inviteExpiration(Integer var1);

        public Builder codeValidation(Boolean var1);
    }
}

