/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wickr.WickrClient;
import software.amazon.awssdk.services.wickr.internal.UserAgentUtils;
import software.amazon.awssdk.services.wickr.model.ListSecurityGroupsRequest;
import software.amazon.awssdk.services.wickr.model.ListSecurityGroupsResponse;
import software.amazon.awssdk.services.wickr.model.SecurityGroup;

public class ListSecurityGroupsIterable
implements SdkIterable<ListSecurityGroupsResponse> {
    private final WickrClient client;
    private final ListSecurityGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSecurityGroupsIterable(WickrClient client, ListSecurityGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSecurityGroupsResponseFetcher();
    }

    public Iterator<ListSecurityGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SecurityGroup> securityGroups() {
        Function<ListSecurityGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityGroups() != null) {
                return response.securityGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSecurityGroupsResponseFetcher
    implements SyncPageFetcher<ListSecurityGroupsResponse> {
        private ListSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSecurityGroupsResponse nextPage(ListSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityGroupsIterable.this.client.listSecurityGroups(ListSecurityGroupsIterable.this.firstRequest);
            }
            return ListSecurityGroupsIterable.this.client.listSecurityGroups((ListSecurityGroupsRequest)((Object)ListSecurityGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

