/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceStateType {
    ACTIVE("ACTIVE"),
    RESTORING("RESTORING"),
    RECYCLING("RECYCLING"),
    RECYCLED("RECYCLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceStateType> VALUE_MAP;
    private final String value;

    private ResourceStateType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceStateType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceStateType> knownValues() {
        EnumSet<ResourceStateType> knownValues = EnumSet.allOf(ResourceStateType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceStateType.class, ResourceStateType::toString);
    }
}

