/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workdocs.WorkDocsAsyncClient;
import software.amazon.awssdk.services.workdocs.internal.UserAgentUtils;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse;
import software.amazon.awssdk.services.workdocs.model.DocumentMetadata;
import software.amazon.awssdk.services.workdocs.model.FolderMetadata;

public class DescribeFolderContentsPublisher
implements SdkPublisher<DescribeFolderContentsResponse> {
    private final WorkDocsAsyncClient client;
    private final DescribeFolderContentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeFolderContentsPublisher(WorkDocsAsyncClient client, DescribeFolderContentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeFolderContentsPublisher(WorkDocsAsyncClient client, DescribeFolderContentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeFolderContentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeFolderContentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FolderMetadata> folders() {
        Function<DescribeFolderContentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.folders() != null) {
                return response.folders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeFolderContentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<DocumentMetadata> documents() {
        Function<DescribeFolderContentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.documents() != null) {
                return response.documents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeFolderContentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeFolderContentsResponseFetcher
    implements AsyncPageFetcher<DescribeFolderContentsResponse> {
        private DescribeFolderContentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFolderContentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeFolderContentsResponse> nextPage(DescribeFolderContentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeFolderContentsPublisher.this.client.describeFolderContents(DescribeFolderContentsPublisher.this.firstRequest);
            }
            return DescribeFolderContentsPublisher.this.client.describeFolderContents((DescribeFolderContentsRequest)((Object)DescribeFolderContentsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

