/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.worklink.model.WorkLinkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateDomainRequest
extends WorkLinkRequest
implements ToCopyableBuilder<Builder, AssociateDomainRequest> {
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetArn").getter(AssociateDomainRequest.getter(AssociateDomainRequest::fleetArn)).setter(AssociateDomainRequest.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(AssociateDomainRequest.getter(AssociateDomainRequest::domainName)).setter(AssociateDomainRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(AssociateDomainRequest.getter(AssociateDomainRequest::displayName)).setter(AssociateDomainRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> ACM_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcmCertificateArn").getter(AssociateDomainRequest.getter(AssociateDomainRequest::acmCertificateArn)).setter(AssociateDomainRequest.setter(Builder::acmCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcmCertificateArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ARN_FIELD, DOMAIN_NAME_FIELD, DISPLAY_NAME_FIELD, ACM_CERTIFICATE_ARN_FIELD));
    private final String fleetArn;
    private final String domainName;
    private final String displayName;
    private final String acmCertificateArn;

    private AssociateDomainRequest(BuilderImpl builder) {
        super(builder);
        this.fleetArn = builder.fleetArn;
        this.domainName = builder.domainName;
        this.displayName = builder.displayName;
        this.acmCertificateArn = builder.acmCertificateArn;
    }

    public final String fleetArn() {
        return this.fleetArn;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String acmCertificateArn() {
        return this.acmCertificateArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.acmCertificateArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateDomainRequest)) {
            return false;
        }
        AssociateDomainRequest other = (AssociateDomainRequest)((Object)obj);
        return Objects.equals(this.fleetArn(), other.fleetArn()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.acmCertificateArn(), other.acmCertificateArn());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateDomainRequest").add("FleetArn", (Object)this.fleetArn()).add("DomainName", (Object)this.domainName()).add("DisplayName", (Object)this.displayName()).add("AcmCertificateArn", (Object)this.acmCertificateArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "AcmCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.acmCertificateArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateDomainRequest, T> g) {
        return obj -> g.apply((AssociateDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkLinkRequest.BuilderImpl
    implements Builder {
        private String fleetArn;
        private String domainName;
        private String displayName;
        private String acmCertificateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateDomainRequest model) {
            super(model);
            this.fleetArn(model.fleetArn);
            this.domainName(model.domainName);
            this.displayName(model.displayName);
            this.acmCertificateArn(model.acmCertificateArn);
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        @Transient
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Transient
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getAcmCertificateArn() {
            return this.acmCertificateArn;
        }

        public final void setAcmCertificateArn(String acmCertificateArn) {
            this.acmCertificateArn = acmCertificateArn;
        }

        @Override
        @Transient
        public final Builder acmCertificateArn(String acmCertificateArn) {
            this.acmCertificateArn = acmCertificateArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateDomainRequest build() {
            return new AssociateDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkLinkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateDomainRequest> {
        public Builder fleetArn(String var1);

        public Builder domainName(String var1);

        public Builder displayName(String var1);

        public Builder acmCertificateArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

