/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.AvailabilityProviderType;
import software.amazon.awssdk.services.workmail.model.LambdaAvailabilityProvider;
import software.amazon.awssdk.services.workmail.model.RedactedEwsAvailabilityProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AvailabilityConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AvailabilityConfiguration> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(AvailabilityConfiguration.getter(AvailabilityConfiguration::domainName)).setter(AvailabilityConfiguration.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProviderType").getter(AvailabilityConfiguration.getter(AvailabilityConfiguration::providerTypeAsString)).setter(AvailabilityConfiguration.setter(Builder::providerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()}).build();
    private static final SdkField<RedactedEwsAvailabilityProvider> EWS_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EwsProvider").getter(AvailabilityConfiguration.getter(AvailabilityConfiguration::ewsProvider)).setter(AvailabilityConfiguration.setter(Builder::ewsProvider)).constructor(RedactedEwsAvailabilityProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EwsProvider").build()}).build();
    private static final SdkField<LambdaAvailabilityProvider> LAMBDA_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LambdaProvider").getter(AvailabilityConfiguration.getter(AvailabilityConfiguration::lambdaProvider)).setter(AvailabilityConfiguration.setter(Builder::lambdaProvider)).constructor(LambdaAvailabilityProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaProvider").build()}).build();
    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateCreated").getter(AvailabilityConfiguration.getter(AvailabilityConfiguration::dateCreated)).setter(AvailabilityConfiguration.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()}).build();
    private static final SdkField<Instant> DATE_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateModified").getter(AvailabilityConfiguration.getter(AvailabilityConfiguration::dateModified)).setter(AvailabilityConfiguration.setter(Builder::dateModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateModified").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, PROVIDER_TYPE_FIELD, EWS_PROVIDER_FIELD, LAMBDA_PROVIDER_FIELD, DATE_CREATED_FIELD, DATE_MODIFIED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AvailabilityConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String providerType;
    private final RedactedEwsAvailabilityProvider ewsProvider;
    private final LambdaAvailabilityProvider lambdaProvider;
    private final Instant dateCreated;
    private final Instant dateModified;

    private AvailabilityConfiguration(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.providerType = builder.providerType;
        this.ewsProvider = builder.ewsProvider;
        this.lambdaProvider = builder.lambdaProvider;
        this.dateCreated = builder.dateCreated;
        this.dateModified = builder.dateModified;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final AvailabilityProviderType providerType() {
        return AvailabilityProviderType.fromValue(this.providerType);
    }

    public final String providerTypeAsString() {
        return this.providerType;
    }

    public final RedactedEwsAvailabilityProvider ewsProvider() {
        return this.ewsProvider;
    }

    public final LambdaAvailabilityProvider lambdaProvider() {
        return this.lambdaProvider;
    }

    public final Instant dateCreated() {
        return this.dateCreated;
    }

    public final Instant dateModified() {
        return this.dateModified;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ewsProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateModified());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityConfiguration)) {
            return false;
        }
        AvailabilityConfiguration other = (AvailabilityConfiguration)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.providerTypeAsString(), other.providerTypeAsString()) && Objects.equals(this.ewsProvider(), other.ewsProvider()) && Objects.equals(this.lambdaProvider(), other.lambdaProvider()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateModified(), other.dateModified());
    }

    public final String toString() {
        return ToString.builder((String)"AvailabilityConfiguration").add("DomainName", (Object)this.domainName()).add("ProviderType", (Object)this.providerTypeAsString()).add("EwsProvider", (Object)this.ewsProvider()).add("LambdaProvider", (Object)this.lambdaProvider()).add("DateCreated", (Object)this.dateCreated()).add("DateModified", (Object)this.dateModified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ProviderType": {
                return Optional.ofNullable(clazz.cast(this.providerTypeAsString()));
            }
            case "EwsProvider": {
                return Optional.ofNullable(clazz.cast(this.ewsProvider()));
            }
            case "LambdaProvider": {
                return Optional.ofNullable(clazz.cast(this.lambdaProvider()));
            }
            case "DateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "DateModified": {
                return Optional.ofNullable(clazz.cast(this.dateModified()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ProviderType", PROVIDER_TYPE_FIELD);
        map.put("EwsProvider", EWS_PROVIDER_FIELD);
        map.put("LambdaProvider", LAMBDA_PROVIDER_FIELD);
        map.put("DateCreated", DATE_CREATED_FIELD);
        map.put("DateModified", DATE_MODIFIED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityConfiguration, T> g) {
        return obj -> g.apply((AvailabilityConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String providerType;
        private RedactedEwsAvailabilityProvider ewsProvider;
        private LambdaAvailabilityProvider lambdaProvider;
        private Instant dateCreated;
        private Instant dateModified;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityConfiguration model) {
            this.domainName(model.domainName);
            this.providerType(model.providerType);
            this.ewsProvider(model.ewsProvider);
            this.lambdaProvider(model.lambdaProvider);
            this.dateCreated(model.dateCreated);
            this.dateModified(model.dateModified);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getProviderType() {
            return this.providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(AvailabilityProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final RedactedEwsAvailabilityProvider.Builder getEwsProvider() {
            return this.ewsProvider != null ? this.ewsProvider.toBuilder() : null;
        }

        public final void setEwsProvider(RedactedEwsAvailabilityProvider.BuilderImpl ewsProvider) {
            this.ewsProvider = ewsProvider != null ? ewsProvider.build() : null;
        }

        @Override
        public final Builder ewsProvider(RedactedEwsAvailabilityProvider ewsProvider) {
            this.ewsProvider = ewsProvider;
            return this;
        }

        public final LambdaAvailabilityProvider.Builder getLambdaProvider() {
            return this.lambdaProvider != null ? this.lambdaProvider.toBuilder() : null;
        }

        public final void setLambdaProvider(LambdaAvailabilityProvider.BuilderImpl lambdaProvider) {
            this.lambdaProvider = lambdaProvider != null ? lambdaProvider.build() : null;
        }

        @Override
        public final Builder lambdaProvider(LambdaAvailabilityProvider lambdaProvider) {
            this.lambdaProvider = lambdaProvider;
            return this;
        }

        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Instant getDateModified() {
            return this.dateModified;
        }

        public final void setDateModified(Instant dateModified) {
            this.dateModified = dateModified;
        }

        @Override
        public final Builder dateModified(Instant dateModified) {
            this.dateModified = dateModified;
            return this;
        }

        public AvailabilityConfiguration build() {
            return new AvailabilityConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AvailabilityConfiguration> {
        public Builder domainName(String var1);

        public Builder providerType(String var1);

        public Builder providerType(AvailabilityProviderType var1);

        public Builder ewsProvider(RedactedEwsAvailabilityProvider var1);

        default public Builder ewsProvider(Consumer<RedactedEwsAvailabilityProvider.Builder> ewsProvider) {
            return this.ewsProvider((RedactedEwsAvailabilityProvider)((RedactedEwsAvailabilityProvider.Builder)RedactedEwsAvailabilityProvider.builder().applyMutation(ewsProvider)).build());
        }

        public Builder lambdaProvider(LambdaAvailabilityProvider var1);

        default public Builder lambdaProvider(Consumer<LambdaAvailabilityProvider.Builder> lambdaProvider) {
            return this.lambdaProvider((LambdaAvailabilityProvider)((LambdaAvailabilityProvider.Builder)LambdaAvailabilityProvider.builder().applyMutation(lambdaProvider)).build());
        }

        public Builder dateCreated(Instant var1);

        public Builder dateModified(Instant var1);
    }
}

