/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.FolderConfiguration;
import software.amazon.awssdk.services.workmail.model.FolderConfigurationsCopier;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDefaultRetentionPolicyResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, GetDefaultRetentionPolicyResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetDefaultRetentionPolicyResponse.getter(GetDefaultRetentionPolicyResponse::id)).setter(GetDefaultRetentionPolicyResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetDefaultRetentionPolicyResponse.getter(GetDefaultRetentionPolicyResponse::name)).setter(GetDefaultRetentionPolicyResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetDefaultRetentionPolicyResponse.getter(GetDefaultRetentionPolicyResponse::description)).setter(GetDefaultRetentionPolicyResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<FolderConfiguration>> FOLDER_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FolderConfigurations").getter(GetDefaultRetentionPolicyResponse.getter(GetDefaultRetentionPolicyResponse::folderConfigurations)).setter(GetDefaultRetentionPolicyResponse.setter(Builder::folderConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FolderConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, FOLDER_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDefaultRetentionPolicyResponse.memberNameToFieldInitializer();
    private final String id;
    private final String name;
    private final String description;
    private final List<FolderConfiguration> folderConfigurations;

    private GetDefaultRetentionPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.folderConfigurations = builder.folderConfigurations;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasFolderConfigurations() {
        return this.folderConfigurations != null && !(this.folderConfigurations instanceof SdkAutoConstructList);
    }

    public final List<FolderConfiguration> folderConfigurations() {
        return this.folderConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFolderConfigurations() ? this.folderConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDefaultRetentionPolicyResponse)) {
            return false;
        }
        GetDefaultRetentionPolicyResponse other = (GetDefaultRetentionPolicyResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasFolderConfigurations() == other.hasFolderConfigurations() && Objects.equals(this.folderConfigurations(), other.folderConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"GetDefaultRetentionPolicyResponse").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("FolderConfigurations", this.hasFolderConfigurations() ? this.folderConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "FolderConfigurations": {
                return Optional.ofNullable(clazz.cast(this.folderConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("FolderConfigurations", FOLDER_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDefaultRetentionPolicyResponse, T> g) {
        return obj -> g.apply((GetDefaultRetentionPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private List<FolderConfiguration> folderConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDefaultRetentionPolicyResponse model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.folderConfigurations(model.folderConfigurations);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<FolderConfiguration.Builder> getFolderConfigurations() {
            List<FolderConfiguration.Builder> result = FolderConfigurationsCopier.copyToBuilder(this.folderConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFolderConfigurations(Collection<FolderConfiguration.BuilderImpl> folderConfigurations) {
            this.folderConfigurations = FolderConfigurationsCopier.copyFromBuilder(folderConfigurations);
        }

        @Override
        public final Builder folderConfigurations(Collection<FolderConfiguration> folderConfigurations) {
            this.folderConfigurations = FolderConfigurationsCopier.copy(folderConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folderConfigurations(FolderConfiguration ... folderConfigurations) {
            this.folderConfigurations(Arrays.asList(folderConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folderConfigurations(Consumer<FolderConfiguration.Builder> ... folderConfigurations) {
            this.folderConfigurations(Stream.of(folderConfigurations).map(c -> (FolderConfiguration)((FolderConfiguration.Builder)FolderConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDefaultRetentionPolicyResponse build() {
            return new GetDefaultRetentionPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDefaultRetentionPolicyResponse> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder folderConfigurations(Collection<FolderConfiguration> var1);

        public Builder folderConfigurations(FolderConfiguration ... var1);

        public Builder folderConfigurations(Consumer<FolderConfiguration.Builder> ... var1);
    }
}

