/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.EndpointEncryptionMode;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyEndpointEncryptionModeRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, ModifyEndpointEncryptionModeRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(ModifyEndpointEncryptionModeRequest.getter(ModifyEndpointEncryptionModeRequest::directoryId)).setter(ModifyEndpointEncryptionModeRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> ENDPOINT_ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointEncryptionMode").getter(ModifyEndpointEncryptionModeRequest.getter(ModifyEndpointEncryptionModeRequest::endpointEncryptionModeAsString)).setter(ModifyEndpointEncryptionModeRequest.setter(Builder::endpointEncryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointEncryptionMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, ENDPOINT_ENCRYPTION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyEndpointEncryptionModeRequest.memberNameToFieldInitializer();
    private final String directoryId;
    private final String endpointEncryptionMode;

    private ModifyEndpointEncryptionModeRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.endpointEncryptionMode = builder.endpointEncryptionMode;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final EndpointEncryptionMode endpointEncryptionMode() {
        return EndpointEncryptionMode.fromValue(this.endpointEncryptionMode);
    }

    public final String endpointEncryptionModeAsString() {
        return this.endpointEncryptionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointEncryptionModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyEndpointEncryptionModeRequest)) {
            return false;
        }
        ModifyEndpointEncryptionModeRequest other = (ModifyEndpointEncryptionModeRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.endpointEncryptionModeAsString(), other.endpointEncryptionModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyEndpointEncryptionModeRequest").add("DirectoryId", (Object)this.directoryId()).add("EndpointEncryptionMode", (Object)this.endpointEncryptionModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "EndpointEncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.endpointEncryptionModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("EndpointEncryptionMode", ENDPOINT_ENCRYPTION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyEndpointEncryptionModeRequest, T> g) {
        return obj -> g.apply((ModifyEndpointEncryptionModeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private String endpointEncryptionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyEndpointEncryptionModeRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.endpointEncryptionMode(model.endpointEncryptionMode);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getEndpointEncryptionMode() {
            return this.endpointEncryptionMode;
        }

        public final void setEndpointEncryptionMode(String endpointEncryptionMode) {
            this.endpointEncryptionMode = endpointEncryptionMode;
        }

        @Override
        public final Builder endpointEncryptionMode(String endpointEncryptionMode) {
            this.endpointEncryptionMode = endpointEncryptionMode;
            return this;
        }

        @Override
        public final Builder endpointEncryptionMode(EndpointEncryptionMode endpointEncryptionMode) {
            this.endpointEncryptionMode(endpointEncryptionMode == null ? null : endpointEncryptionMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyEndpointEncryptionModeRequest build() {
            return new ModifyEndpointEncryptionModeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyEndpointEncryptionModeRequest> {
        public Builder directoryId(String var1);

        public Builder endpointEncryptionMode(String var1);

        public Builder endpointEncryptionMode(EndpointEncryptionMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

