/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspaces.WorkSpacesAsyncClient;
import software.amazon.awssdk.services.workspaces.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsResponse;

public class DescribeApplicationAssociationsPublisher
implements SdkPublisher<DescribeApplicationAssociationsResponse> {
    private final WorkSpacesAsyncClient client;
    private final DescribeApplicationAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeApplicationAssociationsPublisher(WorkSpacesAsyncClient client, DescribeApplicationAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeApplicationAssociationsPublisher(WorkSpacesAsyncClient client, DescribeApplicationAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeApplicationAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeApplicationAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeApplicationAssociationsResponseFetcher
    implements AsyncPageFetcher<DescribeApplicationAssociationsResponse> {
        private DescribeApplicationAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeApplicationAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeApplicationAssociationsResponse> nextPage(DescribeApplicationAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeApplicationAssociationsPublisher.this.client.describeApplicationAssociations(DescribeApplicationAssociationsPublisher.this.firstRequest);
            }
            return DescribeApplicationAssociationsPublisher.this.client.describeApplicationAssociations((DescribeApplicationAssociationsRequest)((Object)DescribeApplicationAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

