/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesFilter;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesFilterListCopier;
import software.amazon.awssdk.services.workspaces.model.DirectoryIdListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspaceDirectoriesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, DescribeWorkspaceDirectoriesRequest> {
    private static final SdkField<List<String>> DIRECTORY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DirectoryIds").getter(DescribeWorkspaceDirectoriesRequest.getter(DescribeWorkspaceDirectoriesRequest::directoryIds)).setter(DescribeWorkspaceDirectoriesRequest.setter(Builder::directoryIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> WORKSPACE_DIRECTORY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WorkspaceDirectoryNames").getter(DescribeWorkspaceDirectoriesRequest.getter(DescribeWorkspaceDirectoriesRequest::workspaceDirectoryNames)).setter(DescribeWorkspaceDirectoriesRequest.setter(Builder::workspaceDirectoryNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceDirectoryNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(DescribeWorkspaceDirectoriesRequest.getter(DescribeWorkspaceDirectoriesRequest::limit)).setter(DescribeWorkspaceDirectoriesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeWorkspaceDirectoriesRequest.getter(DescribeWorkspaceDirectoriesRequest::nextToken)).setter(DescribeWorkspaceDirectoriesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<DescribeWorkspaceDirectoriesFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeWorkspaceDirectoriesRequest.getter(DescribeWorkspaceDirectoriesRequest::filters)).setter(DescribeWorkspaceDirectoriesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DescribeWorkspaceDirectoriesFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_IDS_FIELD, WORKSPACE_DIRECTORY_NAMES_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD, FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeWorkspaceDirectoriesRequest.memberNameToFieldInitializer();
    private final List<String> directoryIds;
    private final List<String> workspaceDirectoryNames;
    private final Integer limit;
    private final String nextToken;
    private final List<DescribeWorkspaceDirectoriesFilter> filters;

    private DescribeWorkspaceDirectoriesRequest(BuilderImpl builder) {
        super(builder);
        this.directoryIds = builder.directoryIds;
        this.workspaceDirectoryNames = builder.workspaceDirectoryNames;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
    }

    public final boolean hasDirectoryIds() {
        return this.directoryIds != null && !(this.directoryIds instanceof SdkAutoConstructList);
    }

    public final List<String> directoryIds() {
        return this.directoryIds;
    }

    public final boolean hasWorkspaceDirectoryNames() {
        return this.workspaceDirectoryNames != null && !(this.workspaceDirectoryNames instanceof SdkAutoConstructList);
    }

    public final List<String> workspaceDirectoryNames() {
        return this.workspaceDirectoryNames;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<DescribeWorkspaceDirectoriesFilter> filters() {
        return this.filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDirectoryIds() ? this.directoryIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkspaceDirectoryNames() ? this.workspaceDirectoryNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceDirectoriesRequest)) {
            return false;
        }
        DescribeWorkspaceDirectoriesRequest other = (DescribeWorkspaceDirectoriesRequest)((Object)obj);
        return this.hasDirectoryIds() == other.hasDirectoryIds() && Objects.equals(this.directoryIds(), other.directoryIds()) && this.hasWorkspaceDirectoryNames() == other.hasWorkspaceDirectoryNames() && Objects.equals(this.workspaceDirectoryNames(), other.workspaceDirectoryNames()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkspaceDirectoriesRequest").add("DirectoryIds", this.hasDirectoryIds() ? this.directoryIds() : null).add("WorkspaceDirectoryNames", this.hasWorkspaceDirectoryNames() ? this.workspaceDirectoryNames() : null).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).add("Filters", this.hasFilters() ? this.filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryIds": {
                return Optional.ofNullable(clazz.cast(this.directoryIds()));
            }
            case "WorkspaceDirectoryNames": {
                return Optional.ofNullable(clazz.cast(this.workspaceDirectoryNames()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DirectoryIds", DIRECTORY_IDS_FIELD);
        map.put("WorkspaceDirectoryNames", WORKSPACE_DIRECTORY_NAMES_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceDirectoriesRequest, T> g) {
        return obj -> g.apply((DescribeWorkspaceDirectoriesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private List<String> directoryIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> workspaceDirectoryNames = DefaultSdkAutoConstructList.getInstance();
        private Integer limit;
        private String nextToken;
        private List<DescribeWorkspaceDirectoriesFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceDirectoriesRequest model) {
            super(model);
            this.directoryIds(model.directoryIds);
            this.workspaceDirectoryNames(model.workspaceDirectoryNames);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
            this.filters(model.filters);
        }

        public final Collection<String> getDirectoryIds() {
            if (this.directoryIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.directoryIds;
        }

        public final void setDirectoryIds(Collection<String> directoryIds) {
            this.directoryIds = DirectoryIdListCopier.copy(directoryIds);
        }

        @Override
        public final Builder directoryIds(Collection<String> directoryIds) {
            this.directoryIds = DirectoryIdListCopier.copy(directoryIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryIds(String ... directoryIds) {
            this.directoryIds(Arrays.asList(directoryIds));
            return this;
        }

        public final Collection<String> getWorkspaceDirectoryNames() {
            if (this.workspaceDirectoryNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.workspaceDirectoryNames;
        }

        public final void setWorkspaceDirectoryNames(Collection<String> workspaceDirectoryNames) {
            this.workspaceDirectoryNames = WorkspaceDirectoryNameListCopier.copy(workspaceDirectoryNames);
        }

        @Override
        public final Builder workspaceDirectoryNames(Collection<String> workspaceDirectoryNames) {
            this.workspaceDirectoryNames = WorkspaceDirectoryNameListCopier.copy(workspaceDirectoryNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceDirectoryNames(String ... workspaceDirectoryNames) {
            this.workspaceDirectoryNames(Arrays.asList(workspaceDirectoryNames));
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<DescribeWorkspaceDirectoriesFilter.Builder> getFilters() {
            List<DescribeWorkspaceDirectoriesFilter.Builder> result = DescribeWorkspaceDirectoriesFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<DescribeWorkspaceDirectoriesFilter.BuilderImpl> filters) {
            this.filters = DescribeWorkspaceDirectoriesFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<DescribeWorkspaceDirectoriesFilter> filters) {
            this.filters = DescribeWorkspaceDirectoriesFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(DescribeWorkspaceDirectoriesFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<DescribeWorkspaceDirectoriesFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (DescribeWorkspaceDirectoriesFilter)((DescribeWorkspaceDirectoriesFilter.Builder)DescribeWorkspaceDirectoriesFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkspaceDirectoriesRequest build() {
            return new DescribeWorkspaceDirectoriesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspaceDirectoriesRequest> {
        public Builder directoryIds(Collection<String> var1);

        public Builder directoryIds(String ... var1);

        public Builder workspaceDirectoryNames(Collection<String> var1);

        public Builder workspaceDirectoryNames(String ... var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder filters(Collection<DescribeWorkspaceDirectoriesFilter> var1);

        public Builder filters(DescribeWorkspaceDirectoriesFilter ... var1);

        public Builder filters(Consumer<DescribeWorkspaceDirectoriesFilter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

